#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-IusMBMMZMpbHADEVdO4MsI
key:                  dhall-1.42.3-IusMBMMZMpbHADEVdO4MsI
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  adf512483e1fac11ae903c357e9efd3b
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-IusMBMMZMpbHADEVdO4MsI
depends:
    Diff-0.5-As7oyl54eJ7L4x4oG6FyFm
    aeson-2.1.2.1-FLNpA1kYfSp7ISjZQSk2AY
    aeson-pretty-0.8.10-5DpWNueRj20JJgSXuEWCvq
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    atomic-write-0.2.1.1-BzXfNguWjv5aL4kkZcqrf base-4.17.2.1
    base16-bytestring-1.0.2.0-14XjLUSM2wBLXMArv0Z6lr
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-1npN6GIJCWqp0RBxHaC5s
    cborg-0.2.10.0-BnwjwcTom34GlNnlw7KXRh
    cborg-json-0.2.6.0-5TOPV2DO0QXDpQ72btq4c1 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-A5RWX8kHPG43be1XRXMmV0
    data-fix-0.3.4-3BgI7u8wrFL6BoJm9GWjXY deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-FEDvimD8XWiLvJPZQx2Hoo exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-LB73cCFlQTWJoTHmub9RiI
    hashable-1.4.6.0-AVmZwVVVmv9PclG6VBq0Z haskeline-0.8.2
    http-client-0.7.19-uUUIOTRb562pkjpXBVB7U
    http-client-tls-0.3.6.4-GETcVgF6bXAgw5zWx32D
    http-types-0.12.4-7tROZjbzWJo2UxJQcRSyTt
    indexed-traversable-0.1.4-2WKTkNkgrfi8m9oX1GafX8
    megaparsec-9.7.0-h6TIpk0ovfDneD2rtVfdC
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-9yi2QA7rgaeGDUVDh4qvx3
    optparse-applicative-0.18.1.0-FAnW5CL7xM19vds8mfQzEC
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-6xRexgoIMSzYsEWunI5B5
    pretty-simple-4.1.3.0-7VBgteflta55bXEB4DEODE
    prettyprinter-1.7.1-6LAznmhuiuZGYtT9LOkZPA
    prettyprinter-ansi-terminal-1.1.3-1Gx5iZfSbBM4yYdxUe7EWr
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-JQaes2jq5DMI9DamxBEckf
    serialise-0.2.6.1-BMiC7RF1A9zGcMvtr1mucZ template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-2kaRktYhhKKKDRomjoYS3W
    text-short-0.1.6-9tH02BGTOIY7rW1KWbbUGp
    th-lift-instances-0.1.20-1pIRLkWkQblVYs8vENzci time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-CYGJOM1K0tFLPsAESFm1Qp
    unordered-containers-0.2.20-9npXt9Xm1lq5WoODUfmSXc
    vector-0.13.2.0-E9z8CkzpYQwAFSNyB7dwgD

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

