#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-GaJWgo0bBP37PQf9NRLORg
key:                  dhall-1.42.3-GaJWgo0bBP37PQf9NRLORg
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  6f932af4f7f62473e0639bc286394ace
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-GaJWgo0bBP37PQf9NRLORg
depends:
    Diff-0.5-7WhUZGNNqmv2AHgG88fLzI
    aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
    aeson-pretty-0.8.10-FoZoq2L63jY6PFOqAzdYHf
    ansi-terminal-1.0.2-2td7snMYnP5JakUmenPhL1
    atomic-write-0.2.1.1-LcAmDCHxe63B9iucSvVDEE base-4.17.2.1
    base16-bytestring-1.0.2.0-UlhuRwgBIQ75TYKUiV4JF bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4HYxnyEi2mnBK2ectdARDN
    cborg-0.2.10.0-JSSW1iWgRf9BMyMmReUbzK
    cborg-json-0.2.6.0-BX9pedDNXQ3EZ9QKkaNc3N containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-3MKPx1l0dHy73OOEfrcDBi
    data-fix-0.3.4-A9Lj2wRKe3aB34hbPZHfZA deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-DCNfc6qHyhWGj2ztUjRUWC exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-8lCjtVZHrrV4RKbecYRjkM
    hashable-1.4.7.0-LvsgkXc0RJl9ehxeji9DTo haskeline-0.8.2
    http-client-0.7.19-Gua32WeuAi7LtpDxdNLHZk
    http-client-tls-0.3.6.4-Im2XpqDar4e3QdicCLXH1Y
    http-types-0.12.4-5kbj0Cv0rp8HNRwQfelhRA
    indexed-traversable-0.1.4-2BJBYQqmGPr8tnVTwezaGL
    megaparsec-9.7.0-7bO8AQZUPYG8DZNgIOSDEX
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-FfZCDPDUWea9JZl5JGUmKF
    optparse-applicative-0.18.1.0-DIJ4MbtGu3QDLh3tqkvHS0
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-HtzRWL4JBX8EP2VBspy4KU
    pretty-simple-4.1.3.0-LF254hk7OSPIs5SUQG0imo
    prettyprinter-1.7.1-2fDIWQCpfcFF0VMlKg6ON0
    prettyprinter-ansi-terminal-1.1.3-BFsIH7JRjJdG9vbANpn0JH
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-GtjUIC3j80u95XeMq22yYk
    serialise-0.2.6.1-1wgacx4SCX95T5SeJwTC9s template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-3M0hClPTBo22OMx4hemSL1
    text-short-0.1.6-AxNUSXCvmUOFZKxidjG0ww
    th-lift-instances-0.1.20-I3Yv3ray6hoCM5U3aug8iT time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-6c2cEqPZKnV3oQxTlqkOug
    unordered-containers-0.2.20.1-LlrDkEbe6ka5Vid8Nf7fMl
    vector-0.13.2.0-9W9rHKyBrY08EKASla5WO0

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

