#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-A1p7kayuiQ8595ibTaWtYX
key:                  dhall-1.42.3-A1p7kayuiQ8595ibTaWtYX
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  6e6443d2a5aa1b39d162ae5a14c2d7de
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-A1p7kayuiQ8595ibTaWtYX
depends:
    Diff-0.5-F16vv0Gp5cI3oyptWJ575y
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT
    aeson-pretty-0.8.10-Eh8NnpcmY9CGqm5LnFuS6D
    ansi-terminal-1.0.2-2gkFCvfn2OGG2Y2ycr9zsg
    atomic-write-0.2.1.1-DRQBDOQHNei6OboukjNm7j base-4.17.2.1
    base16-bytestring-1.0.2.0-JN2q3BvN0xnLDPu9Hux7SV
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-DLRBsz9VfqUNwIWg4HsHR
    cborg-0.2.10.0-FyqN1HYE5Nv7lMJrPDSCXW
    cborg-json-0.2.6.0-2CoWhwzOhCNFmA9NZukFZp containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-25DhcJxcFAjA2ePrvCJq9j
    data-fix-0.3.4-89JSt6Hk16o1luiGMTrYg7 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-KRh3CxEyBRZB9W8w5Krbv4 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-HqsoV7QLtoI1g9p0QEKrMt
    hashable-1.4.7.0-bh6X3bZPF56LQTYQ27khw haskeline-0.8.2
    http-client-0.7.19-Je5Ncol09LTKkFF5WfHhv1
    http-client-tls-0.3.6.4-EFTVUXlq4cM19RusFvekJW
    http-types-0.12.4-6ojMayzAfwB91OTgOklzJ2
    indexed-traversable-0.1.4-2jca0tWP54e6sSfMY1ZadX
    megaparsec-9.7.0-FV2beEugwl3FKVu1jTXjCD
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-KmmPt5MfJi07BPtstNPoD0
    optparse-applicative-0.18.1.0-7AikOdbhtzBKh97m9q2q6o
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-9Z8RyRYYd1ErrYjYlkxDN
    pretty-simple-4.1.3.0-6S1ykV04dhKFJEQXBNv7cO
    prettyprinter-1.7.1-CmgwT0JRRi5IrbNzmhPK5a
    prettyprinter-ansi-terminal-1.1.3-BlrsJM3468zE3dcFj0Rj2y
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-APNnjCxblnoKMeXmBXkKkr
    serialise-0.2.6.1-FFaX4JKUM5pAxDLu5doXDL template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-Fuxs07UchNi9dfCD1Xw66i
    text-short-0.1.6-7x7MjNSpqmSFbxSF99jVFa
    th-lift-instances-0.1.20-LyXSmIC5Nz33Wp9s2FURrm time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-G7N3YUAqErrKsmfQ3ZzWXl
    unordered-containers-0.2.20.1-98Hg6PuNW0XDqLHXL1727Z
    vector-0.13.2.0-24VaMY7coOLw3wI0c1W3K

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

