#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-9EQLmVLJB099nrSU4clDx8
key:                  dhall-1.42.3-9EQLmVLJB099nrSU4clDx8
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  b8c027dbb31161887975db0a771cb20d
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-9EQLmVLJB099nrSU4clDx8
depends:
    Diff-0.5-ISsha3r0HNr6M4FXs44tpp
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x
    aeson-pretty-0.8.10-7LLoAxhJYrxHVdlJthoYBc
    ansi-terminal-1.0.2-vFVvoY6zrCCEYOqozRT68
    atomic-write-0.2.1.1-IU5Reh2emYSJD3IV4a9kQd base-4.17.2.1
    base16-bytestring-1.0.2.0-6gnnhNAVOchGQBiiZZP74i
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-B227KtiOix4GTDgvxk3FBB
    cborg-0.2.10.0-8wk5jNebIcbLv3T3bGm5HB
    cborg-json-0.2.6.0-EE85BXqspVN26Tdk4JjyNn containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-2OmcHZshid3HQ5qWsph4OC
    data-fix-0.3.4-HNJUTlmR33HKvsUF1iTdGa deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-3cPrFbwGcfbEVnuEdslVHx exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-CQeAwLmX5daHXJQajf0bdJ
    hashable-1.4.5.0-FUZ3820cmTgAr6H2g2EQN7 haskeline-0.8.2
    http-client-0.7.19-LRfftiQ6YWX88xW4fFXEK8
    http-client-tls-0.3.6.4-3SOG6pMBD126OroBvnbwcp
    http-types-0.12.4-Hsb6Y5xUgLKEUlBrgYk3WM
    indexed-traversable-0.1.4-8RoXG5saZErHeqMhoihF0x
    megaparsec-9.7.0-7jzSygYb9UCHSxVBa30IvK
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-8swvJWOy75N7pbfI8WzbN
    optparse-applicative-0.18.1.0-2IPYcrIwIO6ByK20WziUUn
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-CP6LBikNQKS17FzgtuptQU
    pretty-simple-4.1.3.0-5lf1cQ3H4drE0DLfrcpuJ3
    prettyprinter-1.7.1-AIJZZXuo91NCViNpmKNzcQ
    prettyprinter-ansi-terminal-1.1.3-zpJIE64fpCIqSqesY8J9j
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-IrrbGrT9lim10QS5UtlqtE
    serialise-0.2.6.1-EP70y4zexzO7UZ0IFagaC1 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-5eE5wVke8pd51G4Pnk5oMw
    text-short-0.1.6-CEC4ARCcz4jBsfp8DbF9fi
    th-lift-instances-0.1.20-KHvOtm9IYpA7SHhmzXWEYD time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-51QWcgHKY9Q2M4gdNfLh1f
    unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe
    vector-0.13.2.0-7bZcynEBhMGLMgNICkU4Wg

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

