#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall-docs
version:              1.0.12
visibility:           public
id:                   dhall-docs-1.0.12-DhK6Q0uWNCC6bCfrW63DsU
key:                  dhall-docs-1.0.12-DhK6Q0uWNCC6bCfrW63DsU
license:              BSD-3-Clause
copyright:            2020 Germán Robayo
maintainer:           GenuineGabriella@gmail.com
author:               Germán Robayo
synopsis:             Generate HTML docs from a dhall package
description:
    Use this package if you want to create HTML documentation from your dhall
    packages:

    * See the "Dhall.Docs" module if you want to use this package as a library

    * Use the @dhall-docs@ program from this package if you want an executable

    The "Dhall.Docs" module also contains instructions for how to use this package

category:             Compiler
abi:                  db2af18a1c5d64a7cdb5810d10a23651
exposed:              True
exposed-modules:      Dhall.Docs Dhall.Docs.Core
hidden-modules:
    Dhall.Docs.CodeRenderer Dhall.Docs.Comment Dhall.Docs.Embedded
    Dhall.Docs.Html Dhall.Docs.Markdown Dhall.Docs.Store
    Dhall.Docs.Util Paths_dhall_docs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall-docs
hs-libraries:         HSdhall-docs-1.0.12-DhK6Q0uWNCC6bCfrW63DsU
depends:
    base-4.17.2.1 base16-bytestring-1.0.2.0-UlhuRwgBIQ75TYKUiV4JF
    bytestring-0.11.5.3 containers-0.6.7
    cryptohash-sha256-0.11.102.1-3MKPx1l0dHy73OOEfrcDBi
    dhall-1.42.3-GaJWgo0bBP37PQf9NRLORg directory-1.3.7.1
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    lucid-2.11.20250303-EN6srktvMq0FFGPBADYX2h
    megaparsec-9.7.0-7bO8AQZUPYG8DZNgIOSDEX
    mmark-0.0.7.6-Lu5IRmBadrBJfM98eUtzGC mtl-2.2.2
    optparse-applicative-0.18.1.0-DIJ4MbtGu3QDLh3tqkvHS0
    path-0.9.5-3ik2i70AEeO1G8ny8SRIuV
    path-io-1.8.2-7YVSfzttys4HQi237HtzcT
    prettyprinter-1.7.1-2fDIWQCpfcFF0VMlKg6ON0 text-2.0.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/dhall-docs/html/dhall-docs.haddock
haddock-html:         /usr/share/doc/dhall-docs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

