/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.IPropertyControl;

abstract class ControlGroupChangeListener
implements PropertyChangeListener {
    private final Collection<IPropertyControl> properties;
    private final BooleanProperty mSet;
    protected boolean internalChange;

    public ControlGroupChangeListener(BooleanProperty mSet, IPropertyControl ... properties) {
        this.mSet = mSet;
        this.properties = Arrays.asList(properties);
    }

    void update() {
        if (this.internalChange) {
            return;
        }
        this.internalChange = true;
        this.updateValue();
        this.internalChange = false;
    }

    abstract void updateValue();

    abstract void applyValue(boolean var1, PropertyChangeEvent var2);

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled;
        if (this.internalChange) {
            return;
        }
        if (evt.getSource().equals(this.mSet)) {
            enabled = this.mSet.getBooleanValue();
        } else {
            assert (this.properties.contains(evt.getSource()));
            enabled = true;
        }
        if (enabled) {
            this.internalChange = true;
        }
        this.applyValue(enabled, evt);
        if (enabled && !this.mSet.getBooleanValue()) {
            this.mSet.setValue(true);
        }
        this.internalChange = false;
        this.update();
    }
}

