/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.connectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.maps.AvailableMaps;
import org.freeplane.plugin.ai.tools.connectors.ConnectorEditRequest;
import org.freeplane.plugin.ai.tools.connectors.ConnectorEditRequestItem;
import org.freeplane.plugin.ai.tools.connectors.ConnectorEditResponse;
import org.freeplane.plugin.ai.tools.connectors.ConnectorEditResultItem;
import org.freeplane.plugin.ai.tools.content.ConnectorItem;
import org.freeplane.plugin.ai.tools.edit.AiEditsMarker;
import org.freeplane.plugin.ai.tools.edit.EditOperation;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummary;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummaryFormatter;

public class ConnectorEditTool {
    private final AvailableMaps availableMaps;
    private final AvailableMaps.MapAccessListener mapAccessListener;
    private final MLinkController linkController;
    private final AiEditsMarker aiEditsMarker;

    public ConnectorEditTool(AvailableMaps availableMaps, AvailableMaps.MapAccessListener mapAccessListener, MLinkController linkController) {
        this.availableMaps = Objects.requireNonNull(availableMaps, "availableMaps");
        this.mapAccessListener = mapAccessListener;
        this.linkController = Objects.requireNonNull(linkController, "linkController");
        this.aiEditsMarker = new AiEditsMarker();
    }

    public ConnectorEditResponse editConnectors(ConnectorEditRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Missing request");
        }
        String mapIdentifierValue = this.requireValue(request.getMapIdentifier(), "mapIdentifier");
        UUID mapIdentifier = this.parseMapIdentifier(mapIdentifierValue);
        MapModel mapModel = this.availableMaps.findMapModel(mapIdentifier, this.mapAccessListener);
        if (mapModel == null) {
            throw new IllegalArgumentException("Unknown map identifier: " + mapIdentifierValue);
        }
        List<ConnectorEditRequestItem> items = request.getItems();
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("Missing connector edit items");
        }
        ArrayList<ConnectorEditResultItem> results = new ArrayList<ConnectorEditResultItem>(items.size());
        for (ConnectorEditRequestItem item : items) {
            if (item == null) continue;
            results.add(this.applyEdit(mapModel, item));
        }
        return new ConnectorEditResponse(mapIdentifierValue, results);
    }

    public ToolCallSummary buildToolCallSummary(ConnectorEditRequest request, ConnectorEditResponse response) {
        int itemCount = request == null || request.getItems() == null ? 0 : request.getItems().size();
        int resultCount = response == null || response.getItems() == null ? 0 : response.getItems().size();
        String summaryText = "editConnectors: items=" + itemCount + ", results=" + resultCount;
        return new ToolCallSummary("editConnectors", summaryText, false);
    }

    public ToolCallSummary buildToolCallErrorSummary(ConnectorEditRequest request, RuntimeException error) {
        String message = error == null ? "Unknown error" : error.getMessage();
        String safeMessage = ToolCallSummaryFormatter.sanitizeValue(message == null ? error.getClass().getSimpleName() : message);
        return new ToolCallSummary("editConnectors", "editConnectors error: " + safeMessage, true);
    }

    private ConnectorEditResultItem applyEdit(MapModel mapModel, ConnectorEditRequestItem item) {
        String sourceNodeIdentifier = this.requireValue(item.getSourceNodeIdentifier(), "sourceNodeIdentifier");
        String targetNodeIdentifier = this.requireValue(item.getTargetNodeIdentifier(), "targetNodeIdentifier");
        EditOperation operation = this.requireValue(item.getOperation(), "operation");
        NodeModel sourceNode = mapModel.getNodeForID(sourceNodeIdentifier);
        if (sourceNode == null) {
            throw new IllegalArgumentException("Unknown source node identifier: " + sourceNodeIdentifier);
        }
        NodeModel targetNode = mapModel.getNodeForID(targetNodeIdentifier);
        if (targetNode == null) {
            throw new IllegalArgumentException("Unknown target node identifier: " + targetNodeIdentifier);
        }
        switch (operation) {
            case ADD: {
                return this.addConnector(sourceNode, targetNode, item);
            }
            case DELETE: {
                return this.deleteConnector(sourceNode, targetNodeIdentifier, item);
            }
            case REPLACE: {
                return this.updateConnector(sourceNode, targetNodeIdentifier, item);
            }
        }
        throw new IllegalArgumentException("Unsupported connector operation: " + String.valueOf((Object)operation));
    }

    private ConnectorEditResultItem addConnector(NodeModel sourceNode, NodeModel targetNode, ConnectorEditRequestItem item) {
        ConnectorModel connector = this.linkController.addConnector(sourceNode, targetNode);
        this.applyLabelUpdates(connector, item);
        this.aiEditsMarker.addAiEditsMarkerWithUndo(sourceNode);
        ConnectorItem connectorItem = ConnectorItem.fromConnector(connector);
        return new ConnectorEditResultItem(item.getSourceNodeIdentifier(), item.getTargetNodeIdentifier(), "added", 0, connectorItem);
    }

    private ConnectorEditResultItem updateConnector(NodeModel sourceNode, String targetNodeIdentifier, ConnectorEditRequestItem item) {
        List<ConnectorModel> matches = this.findMatchingConnectors(sourceNode, targetNodeIdentifier, item);
        ConnectorModel connector = this.selectFirstMatch(matches);
        this.applyLabelUpdates(connector, item);
        this.aiEditsMarker.addAiEditsMarkerWithUndo(sourceNode);
        int ignored = Math.max(0, matches.size() - 1);
        ConnectorItem connectorItem = ConnectorItem.fromConnector(connector);
        return new ConnectorEditResultItem(item.getSourceNodeIdentifier(), item.getTargetNodeIdentifier(), "updated", ignored, connectorItem);
    }

    private ConnectorEditResultItem deleteConnector(NodeModel sourceNode, String targetNodeIdentifier, ConnectorEditRequestItem item) {
        List<ConnectorModel> matches = this.findMatchingConnectors(sourceNode, targetNodeIdentifier, item);
        ConnectorModel connector = this.selectFirstMatch(matches);
        ConnectorItem connectorItem = ConnectorItem.fromConnector(connector);
        this.linkController.removeArrowLink(connector);
        this.aiEditsMarker.addAiEditsMarkerWithUndo(sourceNode);
        int ignored = Math.max(0, matches.size() - 1);
        return new ConnectorEditResultItem(item.getSourceNodeIdentifier(), item.getTargetNodeIdentifier(), "deleted", ignored, connectorItem);
    }

    private void applyLabelUpdates(ConnectorModel connector, ConnectorEditRequestItem item) {
        if (connector == null || item == null) {
            return;
        }
        if (item.getSourceLabel() != null) {
            this.linkController.setSourceLabel(connector, item.getSourceLabel());
        }
        if (item.getMiddleLabel() != null) {
            this.linkController.setMiddleLabel(connector, item.getMiddleLabel());
        }
        if (item.getTargetLabel() != null) {
            this.linkController.setTargetLabel(connector, item.getTargetLabel());
        }
    }

    private List<ConnectorModel> findMatchingConnectors(NodeModel sourceNode, String targetNodeIdentifier, ConnectorEditRequestItem item) {
        Collection links = NodeLinks.getLinks((NodeModel)sourceNode);
        ArrayList<ConnectorModel> matches = new ArrayList<ConnectorModel>();
        if (links == null || links.isEmpty()) {
            return matches;
        }
        for (NodeLinkModel link : links) {
            ConnectorModel connector;
            if (!(link instanceof ConnectorModel) || !targetNodeIdentifier.equals((connector = (ConnectorModel)link).getTargetID()) || !this.matchesLabel(connector.getSourceLabel().orElse(null), item.getMatchSourceLabel()) || !this.matchesLabel(connector.getMiddleLabel().orElse(null), item.getMatchMiddleLabel()) || !this.matchesLabel(connector.getTargetLabel().orElse(null), item.getMatchTargetLabel())) continue;
            matches.add(connector);
        }
        if (matches.isEmpty()) {
            throw new IllegalArgumentException("No matching connectors found for source " + sourceNode.createID() + " and target " + targetNodeIdentifier);
        }
        return matches;
    }

    private ConnectorModel selectFirstMatch(List<ConnectorModel> matches) {
        if (matches == null || matches.isEmpty()) {
            throw new IllegalArgumentException("No matching connectors found.");
        }
        return matches.get(0);
    }

    private boolean matchesLabel(String actual, String expected) {
        if (expected == null) {
            return true;
        }
        return Objects.equals(actual, expected);
    }

    private <T> T requireValue(T value, String fieldName) {
        if (value == null) {
            throw new IllegalArgumentException("Missing " + fieldName);
        }
        return value;
    }

    private String requireValue(String value, String fieldName) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing " + fieldName);
        }
        return value;
    }

    private UUID parseMapIdentifier(String mapIdentifier) {
        try {
            return UUID.fromString(mapIdentifier);
        }
        catch (IllegalArgumentException error) {
            throw new IllegalArgumentException("Invalid map identifier: " + mapIdentifier, error);
        }
    }
}

