/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.plugin.ai.tools.content.IconDescriptionResolver;
import org.freeplane.plugin.ai.tools.content.IconsContent;
import org.freeplane.plugin.ai.tools.content.IconsContentRequest;
import org.freeplane.plugin.ai.tools.content.NodeContentPreset;
import org.freeplane.plugin.ai.tools.content.NodeContentValueMatcher;

public class IconsContentReader {
    private final IconController iconController;
    private final IconDescriptionResolver iconDescriptionResolver;

    public IconsContentReader(IconDescriptionResolver iconDescriptionResolver, IconController iconController) {
        this.iconDescriptionResolver = Objects.requireNonNull(iconDescriptionResolver, "iconDescriptionResolver");
        this.iconController = Objects.requireNonNull(iconController, "iconController");
    }

    public IconsContent readIconsContent(NodeModel nodeModel, NodeContentPreset preset) {
        if (nodeModel == null || preset == NodeContentPreset.BRIEF) {
            return null;
        }
        return this.buildIconsContent(nodeModel);
    }

    public IconsContent readIconsContent(NodeModel nodeModel, IconsContentRequest request) {
        if (nodeModel == null || request == null || !request.includesIcons()) {
            return null;
        }
        return this.buildIconsContent(nodeModel);
    }

    public List<String> collectSearchTerms(NodeModel nodeModel, IconsContentRequest request) {
        if (nodeModel == null || request == null || !request.includesIcons()) {
            return Collections.emptyList();
        }
        ArrayList icons = new ArrayList(this.iconController.getIcons(nodeModel, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        if (icons.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> terms = new ArrayList<String>(icons.size() * 2);
        for (NamedIcon icon : icons) {
            String description = this.iconDescriptionResolver.resolveDescription(icon);
            if (description == null || description.isEmpty()) continue;
            terms.add(description);
        }
        return terms;
    }

    public boolean matches(NodeModel nodeModel, IconsContentRequest request, NodeContentValueMatcher valueMatcher) {
        if (nodeModel == null || request == null || !request.includesIcons() || valueMatcher == null) {
            return false;
        }
        List<String> terms = this.collectSearchTerms(nodeModel, request);
        for (String term : terms) {
            if (!valueMatcher.matchesValue(term)) continue;
            return true;
        }
        return false;
    }

    private IconsContent buildIconsContent(NodeModel nodeModel) {
        ArrayList icons = new ArrayList(this.iconController.getIcons(nodeModel, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        if (icons.isEmpty()) {
            return null;
        }
        ArrayList<String> descriptions = new ArrayList<String>(icons.size());
        for (NamedIcon icon : icons) {
            descriptions.add(this.iconDescriptionResolver.resolveDescription(icon));
        }
        return new IconsContent(descriptions);
    }
}

