/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSPageRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.doc.style.css.om.MarginRuleList;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CommentRemover;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Objects;
import org.w3c.dom.DOMException;

public class PageRule
extends BaseCSSDeclarationRule
implements CSSPageRule {
    private static final long serialVersionUID = 1L;
    private PageSelectorList selectorList = null;
    private MarginRuleList marginRules = null;

    public PageRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)6, by);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(30 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        String string = this.getSelectorText();
        if (string.length() != 0 || this.getStyle().getLength() != 0 || this.marginRules != null) {
            StringBuilder stringBuilder = new StringBuilder(96);
            stringBuilder.append("@page");
            if (string.length() != 0) {
                stringBuilder.append(' ').append(string);
            }
            String string2 = this.getStyle().getMinifiedCssText();
            stringBuilder.append('{').append(string2);
            if (this.marginRules != null) {
                if (string2.length() != 0) {
                    stringBuilder.append(';');
                }
                for (MarginRule marginRule : this.marginRules) {
                    stringBuilder.append(marginRule.getMinifiedCssText());
                }
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        String string = this.getSelectorText();
        if (string.length() != 0 || this.getStyle().getLength() != 0 || this.marginRules != null) {
            styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
            simpleWriter.write((CharSequence)"@page");
            if (string.length() != 0) {
                simpleWriter.write(' ');
                simpleWriter.write((CharSequence)string);
            }
            styleFormattingContext.updateContext(this);
            styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
            styleFormattingContext.startStyleDeclaration(simpleWriter);
            this.getStyle().writeCssText(simpleWriter, styleFormattingContext);
            styleFormattingContext.endCurrentContext(this);
            styleFormattingContext.endStyleDeclaration(simpleWriter);
            if (this.marginRules != null) {
                styleFormattingContext.updateContext(this);
                for (MarginRule marginRule : this.marginRules) {
                    marginRule.writeCssText(simpleWriter, styleFormattingContext);
                }
                styleFormattingContext.endCurrentContext(this);
                styleFormattingContext.endRuleList(simpleWriter);
            }
            styleFormattingContext.writeRightCurlyBracket(simpleWriter);
            styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
        }
    }

    public PageSelectorList getSelectorList() {
        return this.selectorList;
    }

    void setSelectorList(PageSelectorList pageSelectorList) {
        this.selectorList = pageSelectorList;
    }

    @Override
    public String getSelectorText() {
        return this.selectorList == null ? "" : this.selectorList.toString();
    }

    @Override
    public void setSelectorText(String string) throws DOMException {
        CSSParser cSSParser = new CSSParser();
        this.selectorList = cSSParser.parsePageSelectorList(string);
    }

    @Override
    public void setCssText(String string) throws DOMException {
        char c;
        string = string.trim();
        int n = string.length();
        int n2 = string.indexOf(123);
        int n3 = string.indexOf(64);
        if (n < 10 || n3 == -1) {
            throw new DOMException(12, "Invalid @page rule: " + string);
        }
        String string2 = CommentRemover.removeComments(string).toString().trim();
        CharSequence charSequence = string2.subSequence(0, 11);
        if (!ParseHelper.startsWithIgnoreCase(charSequence, "@page") || !Character.isWhitespace(c = charSequence.charAt(5)) && c != '{') {
            throw new DOMException(13, "Not a @page rule: " + string);
        }
        if (n2 == -1) {
            throw new DOMException(12, "Invalid @page rule: " + string);
        }
        String string3 = string.substring(n3 + 5, n);
        PageRuleHandler pageRuleHandler = new PageRuleHandler();
        pageRuleHandler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        CSSParser cSSParser = (CSSParser)this.createSACParser();
        cSSParser.setDocumentHandler(pageRuleHandler);
        try {
            cSSParser.parsePageRuleBody(string3);
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(5, cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
    }

    void addMarginRule(MarginRule marginRule) {
        if (this.marginRules == null) {
            this.marginRules = new MarginRuleList(8);
        }
        this.marginRules.add(marginRule);
    }

    public MarginRuleList getMarginRules() {
        return this.marginRules;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Objects.hash(this.marginRules, this.selectorList);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PageRule pageRule = (PageRule)object;
        return Objects.equals(this.marginRules, pageRule.marginRules) && Objects.equals(this.selectorList, pageRule.selectorList);
    }

    @Override
    public PageRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        Object object;
        PageRule pageRule = new PageRule(abstractCSSStyleSheet, this.getOrigin());
        pageRule.selectorList = this.selectorList;
        if (this.marginRules != null) {
            pageRule.marginRules = new MarginRuleList(this.marginRules.size());
            object = this.marginRules.iterator();
            while (object.hasNext()) {
                pageRule.marginRules.add(((MarginRule)object.next()).clone(abstractCSSStyleSheet));
            }
        }
        object = this.getParentStyleSheet().getHref();
        pageRule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), (String)object);
        return pageRule;
    }

    private class PageRuleHandler
    extends BaseCSSDeclarationRule.DeclarationRuleCSSHandler {
        private MarginRule currentMarginRule = null;

        private PageRuleHandler() {
        }

        @Override
        public void startPage(PageSelectorList pageSelectorList) {
            PageRule.this.selectorList = pageSelectorList;
        }

        @Override
        public void endPage(PageSelectorList pageSelectorList) {
        }

        @Override
        public void startMargin(String string) {
            this.currentMarginRule = new MarginRule(PageRule.this.getParentStyleSheet(), PageRule.this.getOrigin(), string);
            this.currentMarginRule.setParentRule(PageRule.this);
            this.setLexicalPropertyListener(this.currentMarginRule.getLexicalPropertyListener());
        }

        @Override
        public void endMargin() {
            PageRule.this.addMarginRule(this.currentMarginRule);
            this.currentMarginRule = null;
            this.setLexicalPropertyListener(PageRule.this.getLexicalPropertyListener());
        }

        @Override
        public void warning(CSSParseException cSSParseException) throws CSSParseException {
            if (PageRule.this.selectorList != null) {
                super.warning(cSSParseException);
            } else {
                AbstractCSSStyleSheet abstractCSSStyleSheet = PageRule.this.getParentStyleSheet();
                if (abstractCSSStyleSheet != null) {
                    abstractCSSStyleSheet.getErrorHandler().ruleParseWarning(PageRule.this, cSSParseException);
                }
            }
        }

        @Override
        public void error(CSSParseException cSSParseException) throws CSSParseException {
            if (PageRule.this.selectorList != null) {
                super.error(cSSParseException);
            } else {
                AbstractCSSStyleSheet abstractCSSStyleSheet = PageRule.this.getParentStyleSheet();
                if (abstractCSSStyleSheet != null) {
                    abstractCSSStyleSheet.getErrorHandler().ruleParseError(PageRule.this, cSSParseException);
                }
            }
        }
    }
}

