/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.opengl.windows.wgl.RECT;

public class PGPU_DEVICE {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] PGPU_DEVICE_size = new int[]{184, 184, 184, 184, 184, 184, 184, 184, 184, 184};
    private static final int[] cb_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] DeviceName_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] DeviceString_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 36, 36, 36};
    private static final int[] Flags_offset = new int[]{164, 164, 164, 164, 164, 164, 164, 164, 164, 164};
    private static final int[] rcVirtualScreen_offset = new int[]{168, 168, 168, 168, 168, 168, 168, 168, 168, 168};
    private static final int[] rcVirtualScreen_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return PGPU_DEVICE_size[mdIdx];
    }

    public static PGPU_DEVICE create() {
        return PGPU_DEVICE.create(Buffers.newDirectByteBuffer((int)PGPU_DEVICE.size()));
    }

    public static PGPU_DEVICE create(ByteBuffer byteBuffer) {
        return new PGPU_DEVICE(byteBuffer);
    }

    public static PGPU_DEVICE derefPointer(long l) {
        return PGPU_DEVICE.create(ElementBuffer.derefPointer((int)PGPU_DEVICE.size(), (long)l, (int)1).getByteBuffer());
    }

    PGPU_DEVICE(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[PGPU_DEVICE.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final PGPU_DEVICE setCb(int n) {
        this.accessor.setIntAt(cb_offset[mdIdx], n);
        return this;
    }

    public final int getCb() {
        return this.accessor.getIntAt(cb_offset[mdIdx]);
    }

    public static int getDeviceNameElemCount() {
        return 32;
    }

    public final PGPU_DEVICE setDeviceName(byte[] byArray, int n, int n2, int n3) {
        int n4 = PGPU_DEVICE.getDeviceNameElemCount();
        ElementBuffer elementBuffer = ElementBuffer.wrap((int)1, (ByteBuffer)this.getBuffer(), (int)DeviceName_offset[mdIdx], (int)n4);
        elementBuffer.put(byArray, n, n2, n3);
        return this;
    }

    public final ByteBuffer getDeviceName() {
        return ElementBuffer.wrap((int)1, (ByteBuffer)this.getBuffer(), (int)DeviceName_offset[mdIdx], (int)PGPU_DEVICE.getDeviceNameElemCount()).getByteBuffer();
    }

    public final byte[] getDeviceName(int n, byte[] byArray, int n2, int n3) {
        int n4 = PGPU_DEVICE.getDeviceNameElemCount();
        ElementBuffer.wrap((int)1, (ByteBuffer)this.getBuffer(), (int)DeviceName_offset[mdIdx], (int)n4).get(n, byArray, n2, n3);
        return byArray;
    }

    public static int getDeviceStringElemCount() {
        return 128;
    }

    public final PGPU_DEVICE setDeviceString(byte[] byArray, int n, int n2, int n3) {
        int n4 = PGPU_DEVICE.getDeviceStringElemCount();
        ElementBuffer elementBuffer = ElementBuffer.wrap((int)1, (ByteBuffer)this.getBuffer(), (int)DeviceString_offset[mdIdx], (int)n4);
        elementBuffer.put(byArray, n, n2, n3);
        return this;
    }

    public final ByteBuffer getDeviceString() {
        return ElementBuffer.wrap((int)1, (ByteBuffer)this.getBuffer(), (int)DeviceString_offset[mdIdx], (int)PGPU_DEVICE.getDeviceStringElemCount()).getByteBuffer();
    }

    public final byte[] getDeviceString(int n, byte[] byArray, int n2, int n3) {
        int n4 = PGPU_DEVICE.getDeviceStringElemCount();
        ElementBuffer.wrap((int)1, (ByteBuffer)this.getBuffer(), (int)DeviceString_offset[mdIdx], (int)n4).get(n, byArray, n2, n3);
        return byArray;
    }

    public final PGPU_DEVICE setFlags(int n) {
        this.accessor.setIntAt(Flags_offset[mdIdx], n);
        return this;
    }

    public final int getFlags() {
        return this.accessor.getIntAt(Flags_offset[mdIdx]);
    }

    public final PGPU_DEVICE setRcVirtualScreen(RECT rECT) {
        ByteBuffer byteBuffer = rECT.getBuffer();
        int n = rcVirtualScreen_size[mdIdx];
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray, 0, n);
        this.accessor.setBytesAt(rcVirtualScreen_offset[mdIdx], byArray);
        return this;
    }

    public final RECT getRcVirtualScreen() {
        return RECT.create(this.accessor.slice(rcVirtualScreen_offset[mdIdx], rcVirtualScreen_size[mdIdx]));
    }
}

