#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-AqGUupjecD93u9HvVwIQJi
key:                  gitit-0.15.1.2-AqGUupjecD93u9HvVwIQJi
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  17bce17b6496ba589320dd80b30cccfb
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-AqGUupjecD93u9HvVwIQJi
depends:
    HStringTemplate-0.8.8-FyjEqwaE7jx13Db910yovB
    HTTP-4000.4.1-IL47zdgJJ1J9eJ3SFNbkxB
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-4ODQ1UQyjV4HqW8vjPOsEA base-4.17.2.1
    base64-bytestring-1.2.1.0-LWeAHO93Hqh8w1c79M45du
    blaze-html-0.9.2.0-7pVTZvIJYQUCkg3YqAUW9g bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-8KamNG4OpJLA5WirlUhov5
    feed-1.3.2.1-AxJxFcZQd9UEnqocUfcv07 filepath-1.4.2.2
    filestore-0.6.5.1-K7KZ9YPmz6LJ0C8CA1OZN1 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-I8zf3CroHkM4dPajYWXKu7
    hoauth2-2.11.0-LqYBLZAg6H5CYznEsHvrO0
    hslogger-1.3.2.0-GXI8IrQwgs65EN7OB62FnA
    http-client-tls-0.3.6.4-IYe2sIHragA22YL3SplOCc
    http-conduit-2.3.9.1-8mObH8kQTvq5rsa8XUzz9R
    json-0.10-BIRUCzNiDpbHzMsk4ELmSI mtl-2.2.2
    network-3.1.4.0-9ZkyLgutzTZFWrHs4BgIgX
    network-bsd-2.8.1.0-swcAcwveQx7rVZe3i59xC
    network-uri-2.6.4.2-HOjMWSH0yhpFPW7mMXqod2
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-Ll8ugtmFV0z7vRNeM43Gzn
    pandoc-types-1.23.1-HaXF2s0CF6BJIUQNlQyvdP parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-AojK1F3ExhxDorHTlNe3sA
    recaptcha-0.1.0.4-DfC9JWEaKMM1CR3CHJOZf7
    safe-0.3.21-DIKqONX7AP7ND62kUZ2Ce
    skylighting-0.14.2-CcN1HhlQgAs4E2Wv456Pwa
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV syb-0.7.3-DwsmCi1fmJmFd2VOkUYSQg
    tagsoup-0.14.8-AOTucCUzlvw4tHlLy02mp8
    temporary-1.3-9rtP6hocReL6fK4gSjxIEA text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-KGsWLSTr2MK3s3we0h5nu3
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-1iuU6oCP4IjAJy2zDGMFKc xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-1wyZtruRFHU374PqvsqX4E
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-GkAZxdOvdN8EVgG7pYfoCL
    zlib-0.7.0.0-6EIhdO5uIpbJqy3Y9UFp26

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

