#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-Bu8Yv2Uuhvz2b0BSZNDKcv
key:                  gitit-0.15.1.2-Bu8Yv2Uuhvz2b0BSZNDKcv
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  6861fc23e84c96f9a2b5d90da2b9e67e
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-Bu8Yv2Uuhvz2b0BSZNDKcv
depends:
    HStringTemplate-0.8.8-7p6RbdBhstd4uW1NpBjZ9I
    HTTP-4000.4.1-GSg3Nv0zptC9SZc5BeWBbF
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3 base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    blaze-html-0.9.2.0-Flt3Tc7vZ1qFeyjyRV9cWw bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-Ij995tUObBJCVa3DvDnqQV
    feed-1.3.2.1-DnzG3Z6i1oG4tS43B17Apu filepath-1.4.2.2
    filestore-0.6.5.1-JdouiTkcJj09PM0pf4xozA ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-8qrncJFk5b8Ec4ePWhpiHE
    hoauth2-2.11.0-4vLFtHVY18eKuwxVVEupxw
    hslogger-1.3.2.0-8xfUHNypshl7eWk4Q3gOmk
    http-client-tls-0.3.6.4-7hFqlCciT2L8ai6mzNcHUq
    http-conduit-2.3.9.1-EMsJl78ssnEDvd6AhQ1nc
    json-0.10-F49pC4egrWZxpn5cFxwPH mtl-2.2.2
    network-3.1.4.0-HEqaUi724nxGs7WtLdNH8M
    network-bsd-2.8.1.0-H3BPsPZV6Cn9i6HUO5wOce
    network-uri-2.6.4.2-2gUAl98MPyzDbzRsnMqG8p
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-Fzw8N8ZO2k5Hl3BPLBeaLm
    pandoc-types-1.23.1-9mn9637jVpGAKyMoiRlEXr parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-1kyQGGmKWocERAlRbbTx7C
    recaptcha-0.1.0.4-7MJbs7Njepc3pZSYxfjP3o
    safe-0.3.21-6MceIPNvQ5TJvgy4CdUtuY
    skylighting-0.14.2-7HhY5uTl6iv7h6XvRY4u3F
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-DvMMPSfjQylGDaZxljQ4qT
    tagsoup-0.14.8-BpsisJPCbB45dZ9EcbeRlM
    temporary-1.3-2ypZUyYRP3aCh80JybXqFu text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-Ez0OPMgQ28f7cvyKTxSCcg
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-Jyl91KWs3Qm4i2y6TI4SVc xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-HaMsuxbnXREBwlc1bnXQLt
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-AXz4yu415tXFnQLbCJ8ZiH
    zlib-0.7.0.0-HIFcmWkMcrQIACPrDtbc6U

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

