#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-A04ZzmFuZvO8RNdHCZ6lD1
key:                  gitit-0.15.1.2-A04ZzmFuZvO8RNdHCZ6lD1
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  c8a672f8434c93729743c88f9afe47c7
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-A04ZzmFuZvO8RNdHCZ6lD1
depends:
    HStringTemplate-0.8.8-2wy0frIAMsSGCuYLXZOwG5
    HTTP-4000.4.1-9AYSU07EKBwz0gP6VImrC
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-56YME0rnoff9HEf3dDitk2 base-4.17.2.1
    base64-bytestring-1.2.1.0-Gcv0cK19O0C10ALYRTEs9u
    blaze-html-0.9.2.0-B9ruHJfpRcR5JjuSNAaIt4 bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-3QRxYyWKOAKDHSMyZRx11w
    feed-1.3.2.1-6XHtiqKnEWO6hetvmMx8k2 filepath-1.4.2.2
    filestore-0.6.5.1-BcWJUwrsMtU4peSM7wFuO8 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-3x56ovEGov38WEAYb0IOYs
    hoauth2-2.12.0-RyTTnf1ruWE0olGshbOkV
    hslogger-1.3.2.0-4OCZzQLwAvj1NdA3deYl0z
    http-client-tls-0.3.6.4-EHp2ApKIbMzCSorMXxum8X
    http-conduit-2.3.9.1-8WpYQnyLKne61lfLOyMZFN
    json-0.10-F49pC4egrWZxpn5cFxwPH mtl-2.2.2
    network-3.1.4.0-1ps2oXOoyxa7GsNgS88GCq
    network-bsd-2.8.1.0-JdWIPcl7b0P9zDYpmiS5k4
    network-uri-2.6.4.2-20b9im5hRHiD5kB2vlJ1JL
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-AS5EStTKxXUC56UstlZINN
    pandoc-types-1.23.1-7Kg78o8ziS1FlfU5gjPOd2 parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-6fLOERitWZgLekqeklTRBb
    recaptcha-0.1.0.4-IpPMoin4GDIBaGTZlGMUVx
    safe-0.3.21-394GYPspEtM9PWWR5I1WHV
    skylighting-0.14.2-59lWHRJKSSyjLi5kdtpHg
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-DvMMPSfjQylGDaZxljQ4qT
    tagsoup-0.14.8-4fHHzgmnQkuIV53Xx9a2Td
    temporary-1.3-7TrsRc1RsGE2CAll4JY0dE text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-GIh1LCzc5jeGMcTb47DpMi
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-E1KdiQGEVQ5Kfp84R8cLaR xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-9qJKdGu3l2l3pZHQcKHKoy
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-5o73jpWeBR9WuY1Z8F4Xc
    zlib-0.7.0.0-5M03NfMqvh04F5NN11Rd2B

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

