#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-644zk0lPR2O10ECAtohkc8
key:                  gitit-0.15.1.2-644zk0lPR2O10ECAtohkc8
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  53b6d57854e1028b861e9d4e5743ebae
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-644zk0lPR2O10ECAtohkc8
depends:
    HStringTemplate-0.8.8-3hHR5KklJGl1CI948WcOXa
    HTTP-4000.4.1-793eRan35SGkAenvkBqFG
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD base-4.17.2.1
    base64-bytestring-1.2.1.0-Ag5zZV14qgS6mSqDcHZ0fu
    blaze-html-0.9.2.0-GSQGyEfgR96HA14H2zM96E bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-Bcqag7etlC0HqcBLsOZxNv
    feed-1.3.2.1-I7NSwLQ0iED5rYjfiiHSYt filepath-1.4.2.2
    filestore-0.6.5.1-v0eh1eDsnzLv46vvbU1Rk ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-uOI9zOY6cJL9ka1Xdo27L
    hoauth2-2.12.0-BesrOfS5qdw9DGzAftFCrh
    hslogger-1.3.2.0-67tEjeRqZPsKjQKIEdwOpU
    http-client-tls-0.3.6.4-KN3JTiWE2EI1kyisYRtf57
    http-conduit-2.3.9.1-9RvHGJGxwHHJpUO7Zqiogv
    json-0.10-F49pC4egrWZxpn5cFxwPH mtl-2.2.2
    network-3.1.4.0-BeHm9PhAGW35QMcXomVSuT
    network-bsd-2.8.1.0-6uH8XpTHnkAJRApgXPpksS
    network-uri-2.6.4.2-FpQrzNLQnEFHV7gxKif8bC
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-CiF3tKLwIiaIh1uGw1EMxf
    pandoc-types-1.23.1-H2H6q3HFzCx7b6tISIEsv6 parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-1juMk6sohWH51Wgy46Y9Gn
    recaptcha-0.1.0.4-FNp9yyRjtWDCgweOvbzSIy
    safe-0.3.21-2QfDol6D5mJHd9hpTIyjO0
    skylighting-0.14.2-5ydOiIgPAG04pnXhzXORG0
    split-0.2.5-eIzaXXEViC764D7Uvb52H syb-0.7.3-DvMMPSfjQylGDaZxljQ4qT
    tagsoup-0.14.8-JJMVPJp8uZCLLJa9fK9t2Y
    temporary-1.3-J74qUD22gWeKClETiHEU0b text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-AYYTpCgI5xKJzCntcb53BM
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-5snBWVKTuAfHhpJGb1J1Rm xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-8jMCVYgOSZmIGo2E72CuSe
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-IZhvH5xDNS47zrfbBmX2Db
    zlib-0.7.0.0-GOInNFOI3XL1A6Gv5OWDAq

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

