#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-1024dX9mBOMEIB1R9RkAda
key:                  gitit-0.15.1.2-1024dX9mBOMEIB1R9RkAda
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  78ecd3e123a71311038530a19551f41d
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-1024dX9mBOMEIB1R9RkAda
depends:
    HStringTemplate-0.8.8-I0XCSqD2okTEywNIjqwcHH
    HTTP-4000.4.1-I2GZEeEaB712x3GEu2mPEG
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-25X5lEqka86CxkXK2BMN9E base-4.17.2.1
    base64-bytestring-1.2.1.0-LNkxyXoRMflHvQaufiNrDL
    blaze-html-0.9.2.0-AcUIY0JSEhx2Asds2f6X2X bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-FbpG5ki7bcm6ZYjDQelQ2n
    feed-1.3.2.1-EXVrhPSPHPWBa7q0eLsNq3 filepath-1.4.2.2
    filestore-0.6.5.1-3ybojPW6ERu7G6q9Q8KyUA ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-INbNUr1vU1iCsSlHWspT8N
    hoauth2-2.13.0-6oSbJmZ6MkV3pZEGD3z4CV
    hslogger-1.3.2.0-7EDc6FRksrmHdfQg0BOO99
    http-client-tls-0.3.6.4-9F9dnl7UwnqJiEPheKe9fy
    http-conduit-2.3.9.1-9jrOaD4KMs3DpKqhiE79kU
    json-0.10-E5T4WT5iwViBQk3qCcvqdq mtl-2.2.2
    network-3.1.4.0-4q2nDdk2jYz5m5sp4PhmqQ
    network-bsd-2.8.1.0-HTZiYrfoO4KH5TE8pbbR7V
    network-uri-2.6.4.2-9vKCxjgvNW3FsGV9sxXDe3
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2.1-ISvPjzLXyiPHqCnB4xRAHo
    pandoc-types-1.23.1-KWkBW6gtHt66Ez8nKAxGf6 parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-En8KGuEyE1eKrUFL64LDNm
    recaptcha-0.1.0.4-EbL7IH6NJSgA1GlMoDLHHZ
    safe-0.3.21-IyrA7K5ohwh1bwsZPWGLKL
    skylighting-0.14.2-Bg8zQNHM6giBZaXGlhMc2p
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-CiEyKdVdKrBBmPO81uKiz6
    tagsoup-0.14.8-HyXTbn90ZAz8lEMkVM3nUY
    temporary-1.3-5ZcHA3uqaJ21DveNvUEfLl text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-DC8qeMch7WsLVa5P2UOml3
    url-2.1.3-D6KOZ0EKGNF8QewJQkK9BK
    utf8-string-1.0.2-9Em8uVxkJRhLhA62Ke5gub
    uuid-1.3.16-9VLFOPsnBzvf8SvKgInQS xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-694hNGFwmXhxdtQcz4UBy
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-4HgL7bxKU6WInuhsVmlWHC
    zlib-0.7.0.0-CnueDZbHDdw8578oe005EW

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

