#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-GuUnSVXsMO6AO8X544zeWM
key:                  gitit-0.15.1.2-GuUnSVXsMO6AO8X544zeWM
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  23cee1b6523e9a7cbf93c4a65993dc64
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-GuUnSVXsMO6AO8X544zeWM
depends:
    HStringTemplate-0.8.8-H2vweGSyhGP1QbX2qtCGW6
    HTTP-4000.4.1-5kdkKw0IJSY3CDLJxbc1mu
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-7cfkxE9Bq2x7khGuVuQDC7 base-4.17.2.1
    base64-bytestring-1.2.1.0-E08AvuQpBHn2sZGuvrNhQw
    blaze-html-0.9.2.0-FdgXo84MQ5nJDnaCr5A0hJ bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-IUpkdsbSAbO8wuGvnLkW2z
    feed-1.3.2.1-1NsWDeVEw81GHp9rcH5A9k filepath-1.4.2.2
    filestore-0.6.5.1-LjDceEZuYqWG2YermTyiYl ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-IVQ2jUtc8GrDw4NkQ3GDyQ
    hoauth2-2.13.0-2hGSNm0XkMkAQRt6hYLAfE
    hslogger-1.3.2.0-61H0ZZSsiCwJhEeRcSHjWy
    http-client-tls-0.3.6.4-FZfhgXWtSdwFiG9MTCDy82
    http-conduit-2.3.9.1-36cvg6VCtE14rRNMl56unc
    json-0.10-2t2VH1T9loa9m5HvGZyA1f mtl-2.2.2
    network-3.1.4.0-GdpHxCm9XS6F665gL00mHk
    network-bsd-2.8.1.0-EzIQXzbyW4525v3gDeiCb1
    network-uri-2.6.4.2-EJq2qAYdDkaFqs6P7Upy96
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.3-FBOSKL2R6HnfZRY5OcDVl
    pandoc-types-1.23.1-FooHGgSrhZ6I4Ezor8MCq9 parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-AELLTL3R5f5HMsp0oxLypG
    recaptcha-0.1.0.4-FABCuFRrHwq6yOW79cbcEF
    safe-0.3.21-G3XWHHk4zW66NY70hs9fn5
    skylighting-0.14.2-54jLJSzlko4BPZGn3ZWDtR
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-3SVfrNQz4RF9JrEUNzpzyO
    tagsoup-0.14.8-9AxGxNHnwLz9K72y8YEQIc
    temporary-1.3-LL3QLilf5Lm35TqwVxnA26 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-FTr8MzzB7GvDvQbR6LtoZZ
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-3XbMxHul1fYLyJyWHBnStc xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-AFxwddCe0ygJ2hgVcEW794
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-LYXgt5F6KNeEYSTMi7Jg00
    zlib-0.7.0.0-7Yfc1skJWQaC11O771G6OU

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

