#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-nW1iMEIp4XA5oyScdZsny
key:                  gitit-0.15.1.2-nW1iMEIp4XA5oyScdZsny
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  6d9b22223ea10fa99b7be1013dfe3d7c
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-nW1iMEIp4XA5oyScdZsny
depends:
    HStringTemplate-0.8.8-KP5k2HK24G43botOzDA9uU
    HTTP-4000.4.1-GDEBmYuL0pm5Uz2YHSw0jf
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-AErwMfn2r5g1Pc6FekWoJb base-4.17.2.1
    base64-bytestring-1.2.1.0-JNpFHiqgYkrlFIHcalimL
    blaze-html-0.9.2.0-FBLNV7ZdEiX1CRroFdfhP1 bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-GAVk8vb7ddX9CmSWZ2Zp5o
    feed-1.3.2.1-BCWu9N4xdfQ3ypE0Y9RtDC filepath-1.4.2.2
    filestore-0.6.5.1-CbP32ajAMimFNRXI6YP8w3 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-DB8Y255UxMcDGdI8gdrT0c
    hoauth2-2.13.0-1Qmq3u5QsUmD5jSbn4tbFO
    hslogger-1.3.2.0-ETVMth68veoCz8cCVRMIfW
    http-client-tls-0.3.6.4-AVJGLtBIuZakSDpEPaS0o
    http-conduit-2.3.9.1-38o9uLhBWEf6IGiqceM3mp
    json-0.10-2t2VH1T9loa9m5HvGZyA1f mtl-2.2.2
    network-3.1.4.0-Ez30o8Wyt6m7hXZSCgqaWo
    network-bsd-2.8.1.0-42APfG1dVv0BIG9nwcd6Pr
    network-uri-2.6.4.2-Db65q7JXyy8EWWIZuTCsbL
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.4-L1FMhefE2btJPQHf0JhXhi
    pandoc-types-1.23.1-6fthPspW0QJ1OkD1OFze7a parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-9Bk1Rk8uHFTJVqAMIpxjnc
    recaptcha-0.1.0.4-4d2zrfQBPkn1vF2YH4bfXt
    safe-0.3.21-JY11j08EGF0I8tPaNSusR6
    skylighting-0.14.3-9Mi3glYR1BKAnVcOGOjgEd
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-3SVfrNQz4RF9JrEUNzpzyO
    tagsoup-0.14.8-6l2hNP4ikoh5VcPWxmMaNT
    temporary-1.3-5537yedaJYW2ftrfAfmMN5 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-DUCTTIVpvitGGXO37UNpbV
    url-2.1.3-7haosrp4OzqA2EEDcUbRMC
    utf8-string-1.0.2-LtGEIYPp5RR87I6rMd4Fpy
    uuid-1.3.16-8pS2SqhJKOHFKkPPUeNATh xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-AppRvV70KKa4ejHup1m6Ir
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-CAzLp6TRXTiO3utXEuOhV
    zlib-0.7.0.0-9RCw7pyUn6iFIiRGsiNi6

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

