#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-2gIBweJTjGN8QD06XRlYCy
key:                  gitit-0.15.1.2-2gIBweJTjGN8QD06XRlYCy
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  77087f425098a90b0b37ce60e08a4632
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-2gIBweJTjGN8QD06XRlYCy
depends:
    HStringTemplate-0.8.8-8KHse5bD1DeWd2d63R28q
    HTTP-4000.4.1-4ooukAZOunOKhYzW9i7g1R
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm base-4.17.2.1
    base64-bytestring-1.2.1.0-AvS7geCgwfzr74cccAlCm
    blaze-html-0.9.2.0-HtuITEJLeBV807zyf9AYJy bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-I7HDChP0JKKAljkVsSvXrN
    feed-1.3.2.1-9FoLn1k27heEpINGno7HaD filepath-1.4.2.2
    filestore-0.6.5.1-DVfTVAqlkUbAeNb0tfXpG6 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-51IVpEJp4Ak5XapIACoG88
    hoauth2-2.13.0-6NCK5RfGp8hDVekkcAb2Wj
    hslogger-1.3.2.0-346FV2Me67i1h1Edy3pwU4
    http-client-tls-0.3.6.4-26jJPqfpxqfJih66sxENJC
    http-conduit-2.3.9.1-9lb1s1DMGG5nRl3jzoZw2
    json-0.10-2t2VH1T9loa9m5HvGZyA1f mtl-2.2.2
    network-3.1.4.0-5tdSDQBC1SF9do6vOgsoy3
    network-bsd-2.8.1.0-4m5U2an7rFRBUNL6ghciIU
    network-uri-2.6.4.2-60V3uLcyBv8HHhnYdb8knn
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.4-D5qfNx0buPoCalkagfxaDa
    pandoc-types-1.23.1-9od9h6FLVClGedcrzJafau parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-Kx84bR0MhuXELN1ev6GdTW
    recaptcha-0.1.0.4-GkCWZHACYG4AmMwobnCyQm
    safe-0.3.21-Esyyru5CUzTFDSdkcA7Wuj
    skylighting-0.14.3-7CEvAConFpPLN3thUAnwOw
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-3SVfrNQz4RF9JrEUNzpzyO
    tagsoup-0.14.8-19ukk4vIPuT5iti1IAcjq7
    temporary-1.3-KbjBnRExPZiB3fvyB84Pcu text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-KaRvJSJsp2L2GOri1lcvV4
    url-2.1.3-jjbBGEOjJYFft9Ro2jdsn
    utf8-string-1.0.2-Kx3GnjsHBwcIRYSetT14kb
    uuid-1.3.16-BGbd2DS4gajB9FP9VbIx28 xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-86ynJRlLKv1I6k3rZwrMdV
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-7pACqfsRj1p5mCZyIOUWww
    zlib-0.7.0.0-GZwXF91tZuf1r1Pp8hVGlr

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

