---
stage: Fulfillment
group: Utilization
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ストレージ
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供: GitLab.com

{{< /details >}}

## Freeの制限

{{< details >}}

- プラン: Free

{{< /details >}}

GitLab.comのすべてのFreeプロジェクトには、GitリポジトリとLarge File Storage（LFS）用に10 GiBの無料ストレージがあります。

プロジェクトのリポジトリとLFSが10 GiBを超えると、プロジェクトは読み取り専用状態に設定されます。読み取り専用プロジェクトに変更をプッシュすることはできません。プロジェクトのリポジトリとLFSのストレージを10 GiBより大きくするには、[ストレージを追加購入する](../subscriptions/gitlab_com/_index.md#purchase-more-storage)必要があります。

ストレージ制限が適用されるのは、プロジェクトのリポジトリとLFSのみです。この制限は、コンテナレジストリ、パッケージレジストリ、ビルドアーティファクトには適用されません。

## ストレージを表示する

{{< details >}}

- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

プロジェクトおよびネームスペースのストレージ使用量について、以下の統計を表示できます。

- GitLab.comのストレージ制限または[Self-Managedのストレージ制限](../administration/settings/account_and_limit_settings.md#repository-size-limit)を超えるストレージ使用量。
- GitLab.comで利用可能な購入済みストレージ。

前提要件:

- プロジェクトのストレージ使用量を表示するには、少なくともプロジェクトのメンテナーロールまたはネームスペースのオーナーロールが必要です。
- グループネームスペースのストレージ使用量を表示するには、ネームスペースのオーナーロールが必要です。

ストレージを表示するには、次の手順に従います。

1. 左側のサイドバーで**検索または移動**を選択し、プロジェクトまたはグループを見つけます。
1. **設定 > 使用量割り当て**を選択します。
1. **ストレージ**タブを選択し、ネームスペースのストレージ使用量を確認します。
1. プロジェクトのストレージ使用量を表示するには、下部のテーブルでプロジェクトを選択します。ストレージ使用量は90分ごとに更新されます。

ネームスペースに`'Not applicable.'`が表示される場合は、ネームスペース内の任意のプロジェクトにコミットをプッシュして、ストレージを再計算します。

ストレージとネットワークの使用量は、バイナリ測定システム（1024ユニットの倍数）で計算されます。ストレージ使用量は、キビバイト（KiB）、メビバイト（MiB）、ギビバイト（GiB）で表示されます。1 KiBは2^10バイト（1024バイト）、1 MiBは2^20バイト（1024キビバイト）、1 GiBは2^30バイト（1024メビバイト）です。

## プロジェクトフォークのストレージ使用量を表示する

プロジェクトフォークによって消費されるストレージにコストファクターが適用されるため、フォークが実際のサイズよりも少なくネームスペースストレージを消費するようになります。フォークストレージ削減のコストファクターは、ネームスペースストレージにのみ適用されます。コストファクターは、プロジェクトリポジトリのストレージ制限には適用されません。

フォークが使用したネームスペースストレージの量を表示するには、次の手順に従います。

1. 左側のサイドバーで**検索または移動**を選択し、プロジェクトまたはグループを見つけます。
1. **設定 > 使用量割り当て**を選択します。
1. **ストレージ**タブを選択します。**合計**列には、フォークがディスク上の実際のフォークサイズの割り当てとして使用するネームスペースストレージの量が表示されます。

コストファクターは、プロジェクトリポジトリ、LFSオブジェクト、ジョブアーティファクト、パッケージ、スニペット、Wikiに適用されます。

コストファクターは、Freeプランのネームスペースのプライベートフォークには適用されません。

## 超過ストレージ使用量

{{< details >}}

- プラン: Free

{{< /details >}}

超過ストレージ使用量とは、プロジェクトのリポジトリとLFSの10 GiBの無料ストレージを超える量のことです。購入したストレージが利用できない場合、プロジェクトは読み取り専用状態に設定されます。読み取り専用プロジェクトに変更をプッシュすることはできません。

読み取り専用状態を削除するには、ネームスペースの[ストレージを追加購入する](../subscriptions/gitlab_com/_index.md#purchase-more-storage)必要があります。購入が完了すると、読み取り専用状態が削除され、プロジェクトが自動的に復元されます。利用可能な購入済みストレージの量は、常にゼロより大きくなければなりません。

**使用量割り当て**ページの**ストレージ**タブには、次のことが示されます。

- 利用可能な購入済みストレージの残量が少なくなっている。
- 利用可能な購入済みストレージがゼロの場合、読み取り専用になるリスクがあるプロジェクト。
- 利用可能な購入済みストレージがゼロであるため、読み取り専用になっているプロジェクト。読み取り専用プロジェクトは、名前の横に情報アイコン（{{< icon name="information-o" >}}）が表示される。

合計ストレージには、無料ストレージと購入済みの超過ストレージが含まれます。残っている超過ストレージはパーセントで表示され、次のように計算されます。100％ - ((超過ストレージ使用量 - 購入済みの超過ストレージ) * 100)。

### 超過ストレージの例

次の例では、ネームスペース内のプロジェクトの超過ストレージのシナリオを示しています。

| リポジトリ | ストレージ使用量 | 超過ストレージ | 割り当て  | 状態               |
|------------|--------------|----------------|--------|----------------------|
| 赤        | 10 GiB        | 0 GiB           | 10 GiB  | 読み取り専用 {{< icon name="lock" >}} |
| 青       | 8 GiB         | 0 GiB           | 10 GiB  | 読み取り専用ではない        |
| 緑      | 10 GiB        | 0 GiB           | 10 GiB  | 読み取り専用 {{< icon name="lock" >}} |
| 黄     | 2 GiB         | 0 GiB           | 10 GiB  | 読み取り専用ではない        |
| **合計** | **30 GiB**    | **0 GiB**       | –      | –                    |

赤と緑のプロジェクトは、リポジトリとLFSが割り当てに達しているため、読み取り専用になっています。この例では、追加のストレージはまだ購入されていません。

赤と緑のプロジェクトから読み取り専用状態を削除するには、50 GiBの追加ストレージを購入します。

一部のプロジェクトのリポジトリとLFSが10 GiBの割り当てを超えると、利用可能な購入済みストレージが減少します。

| リポジトリ | ストレージ使用量 | 超過ストレージ | 割り当て   | 状態            |
|------------|--------------|----------------|---------|-------------------|
| 赤        | 15 GiB        | 5 GiB         | 10 GiB  | 読み取り専用ではない     |
| 青       | 14 GiB        | 4 GiB         | 10 GiB  | 読み取り専用ではない     |
| 緑      | 11 GiB        | 1 GiB         | 10 GiB  | 読み取り専用ではない     |
| 黄     | 5 GiB         | 0 GiB         | 10 GiB  | 読み取り専用ではない     |
| **合計** | **45 GiB**    | **10 GiB**    | –       | –                 |

この例では、次のようになっています。

- 利用可能な購入済みストレージは40 GiBです。50 GiB（購入済みストレージ）- 10 GiB（使用された合計超過ストレージ）。その結果、プロジェクトは読み取り専用ではなくなりました。
- 超過ストレージ使用量は20％です。10 GiB / 50 GiB * 100。
- 残りの購入済みストレージは80％です。

## ストレージ使用量を管理する

ストレージを管理するために、Free GitLab.comネームスペースのネームスペースオーナーは、[ネームスペースのストレージを追加購入する](../subscriptions/gitlab_com/_index.md#purchase-more-storage)ことができます。

PremiumプランとUltimateプランでは、ロール次第ですが、[リポジトリサイズを削減](project/repository/repository_size.md#methods-to-reduce-repository-size)することもできます。ストレージ使用量の分析と管理を自動化するには、[ストレージ管理の自動化](storage_management_automation.md)を参照してください。

ストレージ使用量の管理に加えて、使用可能なストレージを増やすために、次のオプションを検討することができます。

- 対象となる場合は、次の[コミュニティプログラムサブスクリプション](../subscriptions/community_programs.md)に申し込む。
  - 教育団体向けGitLab
  - オープンソース団体向けGitLab
  - スタートアップ向けGitLab
- ストレージ制限のない[GitLab Self-Managedサブスクリプション](../subscriptions/self_managed/_index.md)を検討する。
- オプションの詳細について、[エキスパートに相談する](https://page.gitlab.com/usage_limits_help.html)。

## プロジェクトの固定制限

{{< details >}}

- プラン: Premium、Ultimate

{{< /details >}}

プロジェクトのリポジトリとLFSが500 GiBを超えると、プロジェクトは読み取り専用状態になります。この場合、グループとトップレベルネームスペースのオーナーは、ストレージ使用量を管理するように警告するアプリ内通知とメール通知を受け取ります。アカウントチームとサポートチームと協力して、使用量を管理できます。500 GiBの固定されたプロジェクト制限は、プラットフォーム全体の安定性を確保するために設けられています。

## 期限切れのストレージ

ストレージがサブスクリプション期間の終了時に誤ってプロビジョニング解除されない場合、期限切れのストレージがサブスクリプションに存在するようになる可能性があります。購入済みストレージが予想外に減少した場合は、期限切れのストレージがアカウントから削除された可能性があります。詳細とソリューションについては、サポートにお問い合わせください。

## 関連トピック

- [ストレージ管理の自動化](storage_management_automation.md)
- [ストレージを購入する](../subscriptions/gitlab_com/_index.md#purchase-more-storage)
