# frozen_string_literal: true

class AddNamespaceFkToGranularScopes < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!

  milestone '18.4'

  def up
    add_concurrent_foreign_key :granular_scopes, :namespaces,
      column: :namespace_id, on_delete: :cascade
  end

  def down
    with_lock_retries do
      remove_foreign_key :granular_scopes, column: :namespace_id
    end
  end
end
