---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab incoming email token'
---

## Description

The response body contains content that matches the pattern of a GitLab incoming email token was identified. Your incoming email token authenticates you when you create a new issue by email, and is included in your personal project-specific email addresses. It cannot be used to access any other data. A malicious actor with access to this token can create issues as if they were you.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To regenerate a feed token:

- Sign in to your GitLab account and access the [User settings](../../../../../user/profile/_index.md#access-your-user-settings) left-hand side menu, select "Access tokens"
- Under the "Incoming email token" section, select the "reset this token" link
- When prompted select "OK"

For more information, please see [GitLabs documentation on feed tokens](../../../../../security/tokens/_index.md#feed-token).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.149 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
