#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-9ebV7eWCiZtGT4Sibv1CPm
key:                  glirc-2.40-9ebV7eWCiZtGT4Sibv1CPm
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  c477679b1f02c7adb194d2a0d802f9fb
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-9ebV7eWCiZtGT4Sibv1CPm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-AEEbz4V6SgDBM9bfVTZpGL
    async-2.2.5-75FFlJsh5XPALDlYx1XYqh
    attoparsec-0.14.4-BOYjI7Xnyxi2UxSSzbjWOG base-4.17.2.1
    base64-bytestring-1.2.1.0-9K52dGT2jL1Hyh8Ww36box
    bytestring-0.11.5.3 config-schema-1.3.0.0-52IDRaYu2b1MASQK9hZDv
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-E37EShLF9SF6ImJ41XFCr5 directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-H77Y1FOABcG1aE0DdSWKil
    githash-0.1.6.3-Jif88qBxw2QBDvDs7Q0Zx3
    hashable-1.4.4.0-D3m6G7BPJON5VQ2FLdROoK
    hookup-0.8-EprWw23FkGv7blisJAa0BJ
    irc-core-2.12-LH7J7DnKDvx9b0Gz89cjWj
    kan-extensions-5.2.7-JjiIZZzqtTtLuirs0Ujh9z
    lens-5.3.1-EJGBiJ62DpEHaBgUJVPkQg
    network-3.1.4.0-5uK3u4RW2BBBzIyfRS5Jps
    psqueues-0.2.8.2-8ipiW2f50tn1V4Hxc5DMGX
    random-1.2.1.3-Hc2Rnu5BTd49WL1xp2j5Li
    regex-tdfa-1.3.2.4-EhX7jCEB4hYAzMd1ZradSc
    semigroupoids-6.0.1-IX14cCzXj5OGCpqk21QrPT
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-GNkDU8egPHO3w2KWon3YX7
    unix-2.7.3 unordered-containers-0.2.20-3371VA61Be1CojVrkG24uM
    vector-0.13.2.0-EWs7nDhBFQF5RfgCWU6KmC
    vty-6.2-LBIoPshuIf43YWUh0pAReC

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

