#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-1NeVDYRI1rKBlQZv87nZ9U
key:                  glirc-2.40.1-1NeVDYRI1rKBlQZv87nZ9U
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  e7f95717fad740f986c8b1ef164c66d8
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-1NeVDYRI1rKBlQZv87nZ9U
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-Ckzor9xVcmT3LojIItKUEL
    async-2.2.5-6I3Om2iOc9KLV2rb6dASmz
    attoparsec-0.14.4-Kqu9azGoeFY4BlHGbH5HBg base-4.17.2.1
    base64-bytestring-1.2.1.0-Cf5znIQf1Nf25Cl2XqzapR
    bytestring-0.11.5.3 config-schema-1.3.0.0-EV7c55MY7XcD2YHTSFN7vF
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-KEf9tMs4qQXJQBi28IYXbh directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-KHHkmu51Uvs7lnbXoJINPa
    githash-0.1.6.3-9aK9FTRVlnxJ13xvjdPA0S
    hashable-1.4.4.0-EdBgVbn6YIuE9bA3dwmz04
    hookup-0.8-gLkxYBseEEECW1lRGlXx0
    irc-core-2.12-ChuMJBQYggqJcjalS8WOn5
    kan-extensions-5.2.7-5TNadmEhpvk84V1hzzcFfj
    lens-5.3.1-39Rj9LQQhPID4B1jmyDMFk
    network-3.1.4.0-DD61ZgteIR5Dyq0QRyt6FX
    psqueues-0.2.8.2-6QE0hu7PanE34cAmyrORrm
    random-1.2.1.3-Dut5c8vSKZWHge6fwh5bUA
    regex-tdfa-1.3.2.4-IrQPD9ooo505JdGPODvYYe
    semigroupoids-6.0.1-KCNtGml05AHAYKR3WNsoxY
    split-0.2.5-42FGdeEiiUOLLQR1FNYPlK stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-EN8w2leKh5AGV7Qq1MMHiN
    unix-2.7.3 unordered-containers-0.2.20-8cMd7edANcDBeBDjVdjsZY
    vector-0.13.2.0-4gUGda2ISIbCv9ACnxMPCL
    vty-6.2-6jZylV5u3mR8jwdkpkHoeB

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

