#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-IGSdlc3txEeAX0udJRprUH
key:                  glirc-2.40.1-IGSdlc3txEeAX0udJRprUH
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  a3e67e8ec5f3998da9ec032342f1ba60
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-IGSdlc3txEeAX0udJRprUH
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-2FxNi9z55AUHvPBqvoEmvy
    async-2.2.5-HN0qvlEHg8UJWHhrUVAn33
    attoparsec-0.14.4-LQtEgQtiyVz1VW0BNcPBCE base-4.17.2.1
    base64-bytestring-1.2.1.0-629Bo7Gc9ZF7jdkMFmzdCw
    bytestring-0.11.5.3 config-schema-1.3.0.0-Gdewqe8zdl5KKkYBNbkFQH
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-KgnVvdG5vKs8Den0dzpVKh directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-71fbrzB20syG3JIIOZHARR
    githash-0.1.6.3-HPn8TtP68ADBPjzHJuZtHu
    hashable-1.4.7.0-5RC0vb199EtDGUMphsJuko
    hookup-0.8-BZTVYQVw6YAExtC5QcugDP
    irc-core-2.12-54hlBkaF8pbDAQO1W8IjOO
    kan-extensions-5.2.7-JqyNmiNAbIjJgL0VygyiAk
    lens-5.3.3-JbVUFNwOeNUGLciYleU4If
    network-3.1.4.0-IC0hdE8eZqJ6PeeNglfLy3
    psqueues-0.2.8.2-H7873MqHPgcHz6AJleT4Ct
    random-1.2.1.3-Lrb8TDGfTan4fST0eiDAa7
    regex-tdfa-1.3.2.5-3jfIfS23fhoC4PyiafLhmq
    semigroupoids-6.0.1-8zC5qIb5J6RGNzZ2QaMrgF
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-AALcG74pyjuJStEjl1zCsW
    unix-2.7.3 unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    vector-0.13.2.0-JUxTFkVHiOCDvdzFqkdqvm
    vty-6.2-ELGi9uZ18R5K15LbAPP38M

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

