#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-5sCXp7US5YIA0ioHoXtZI0
key:                  glirc-2.40.1-5sCXp7US5YIA0ioHoXtZI0
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  636a42cea905f869f7f803bbb581377a
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-5sCXp7US5YIA0ioHoXtZI0
include-dirs:         /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-2uHnblGQrlR6AJATuEk3WX
    async-2.2.5-7QLouev6UZnCRkgh8pzL0M
    attoparsec-0.14.4-ARFIPKVHAQdH6rZ1P31wQY base-4.18.2.1
    base64-bytestring-1.2.1.0-9LHYaxMplJVGg4IRiFtzGp
    bytestring-0.11.5.3 config-schema-1.3.0.0-CNpjAQGl1vZJbespou690Q
    config-value-0.8.3-IWIlPmbx9u07ZPnTUBDeDU containers-0.6.7
    curve25519-0.2.8.1-ESptWaiDXjQJO3EmPk8ByU directory-1.3.8.5
    filepath-1.4.300.1 free-5.2-C0wMFPaeM7d2Gj3dQuebRq
    githash-0.1.6.3-EpV0NuIZ16XAVHfRSsg0LL
    hashable-1.4.7.0-9Up8LPJnqTG92zCMBiHaIh
    hookup-0.8-2Fy9hdxAbigE3UCguWTACb
    irc-core-2.12-G5UvtuLQImhFAIstc3IARg
    kan-extensions-5.2.7-AZcY5gs8CjL8JkHlOtsUeD
    lens-5.3.3-ATynRreA1Nv2YBaKYxJYCc
    network-3.1.4.0-Kxe15bkS84aBmhotDoAJWo
    psqueues-0.2.8.2-6Gou2U28V1IFASWPFB5eqG
    random-1.2.1.3-9qHMSsHBK1nLlbyddD4wR1
    regex-tdfa-1.3.2.5-HbcBjlVCDu1Hxg2xP0HSjv
    semigroupoids-6.0.1-94KNkvJm0CV8wcScT9KnVQ
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2 time-1.12.2
    transformers-0.6.1.0 typed-process-0.2.13.0-HJKsarBC97zD3ptdaSZFlu
    unix-2.8.4.0 unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    vector-0.13.2.0-3Co1wNPhccp6XnsJEn8cXR
    vty-6.2-GJSVM62QIvN9hRMOjtPpjh

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

