/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.NumberUtils;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.XYpoint;
import tim.prune.function.compress.methods.CompressionMethod;

public class DouglasPeuckerMethod
extends CompressionMethod {
    private final int _factor;

    public DouglasPeuckerMethod(int n) {
        this._factor = n;
    }

    public DouglasPeuckerMethod(String string) {
        this._factor = DouglasPeuckerMethod.recogniseString(string) ? NumberUtils.getIntOrZero(string.substring(4)) : (int)NumberUtils.getDoubleOrZero(string);
    }

    @Override
    public CompressionMethodType getType() {
        return CompressionMethodType.DOUGLAS_PEUCKER;
    }

    @Override
    public String getParam() {
        return "" + Math.abs(this._factor);
    }

    @Override
    public int compress(Track track, TrackDetails trackDetails, MarkingData markingData) {
        double d = this._factor <= 0 ? 1.0 : 1.0 / (double)this._factor;
        double d2 = trackDetails.getTrackSpan() * d;
        int n = track.getNumPoints();
        int n2 = markingData.getNumDeleted();
        int[] nArray = new int[n];
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n) {
            DataPoint dataPoint = track.getPoint(n5);
            if (dataPoint.getSegmentStart() && n3 > -1 && n4 > n3) {
                nArray[n4] = 1;
                this.compressSegment(track, nArray, n3, n4, d2);
                n4 = -1;
                n3 = -1;
            }
            if (markingData.isPointMarkedForDeletion(n5)) {
                nArray[n5] = -1;
            } else if (dataPoint.isWaypoint() || dataPoint.hasMedia() || dataPoint.getSegmentStart()) {
                nArray[n5] = 1;
            }
            if (!markingData.isPointMarkedForDeletion(n5) && !dataPoint.isWaypoint()) {
                if (n3 < 0) {
                    n3 = n5;
                } else {
                    n4 = n5;
                }
            }
            ++n5;
        }
        if (n3 >= 0 && n4 > n3) {
            nArray[n4] = 1;
            this.compressSegment(track, nArray, n3, n4, d2);
        }
        n5 = 1;
        while (n5 < n) {
            if (nArray[n5] < 1) {
                markingData.markPointForDeletion(n5);
            }
            ++n5;
        }
        return markingData.getNumDeleted() - n2;
    }

    private void compressSegment(Track track, int[] nArray, int n, int n2, double d) {
        int n3 = n2 - n + 1;
        if (n3 < 3) {
            return;
        }
        XYpoint xYpoint = new XYpoint(track.getX(n), track.getY(n));
        XYpoint xYpoint2 = new XYpoint(track.getX(n2), track.getY(n2));
        XYpoint xYpoint3 = xYpoint.vectorTo(xYpoint2);
        double d2 = xYpoint3.len2();
        double d3 = xYpoint3.len();
        XYpoint xYpoint4 = new XYpoint(xYpoint3.y / d3, -xYpoint3.x / d3);
        if (d3 <= 0.0) {
            int n4 = this.getFurthestPointIndex(track, n, n2);
            if (n4 > n) {
                this.compressSegment(track, nArray, n, n4, d);
                this.compressSegment(track, nArray, n4, n2, d);
            }
            return;
        }
        double d4 = -1.0;
        int n5 = -1;
        int n6 = n + 1;
        while (n6 < n2) {
            XYpoint xYpoint5;
            XYpoint xYpoint6;
            double d5;
            double d6;
            if (nArray[n6] == 0 && (d6 = (d5 = xYpoint3.dot(xYpoint6 = xYpoint.vectorTo(xYpoint5 = new XYpoint(track.getX(n6), track.getY(n6)))) / d2) < 0.0 ? xYpoint6.len() : (d5 > 1.0 ? xYpoint2.vectorTo(xYpoint5).len() : Math.abs(xYpoint4.dot(xYpoint6)))) > d4) {
                d4 = d6;
                n5 = n6;
            }
            ++n6;
        }
        if (d4 > d) {
            nArray[n5] = 1;
            this.compressSegment(track, nArray, n, n5, d);
            this.compressSegment(track, nArray, n5, n2, d);
        }
    }

    private int getFurthestPointIndex(Track track, int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n2 > n) {
            DataPoint dataPoint = track.getPoint(n);
            double d = 0.0;
            int n4 = n + 1;
            while (n4 < n2) {
                double d2;
                DataPoint dataPoint2 = track.getPoint(n4);
                if (!dataPoint2.isWaypoint() && (d2 = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2)) > d) {
                    n3 = n4;
                    d = d2;
                }
                ++n4;
            }
        }
        return n3;
    }

    @Override
    public String getSettingsString() {
        return String.valueOf(this.getType().getKey()) + this._factor;
    }

    static boolean recogniseString(String string) {
        return DouglasPeuckerMethod.recogniseString(string, CompressionMethodType.DOUGLAS_PEUCKER);
    }
}

