/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report;

import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.RepositoryAwareVerificationFailure;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.AbstractTextDependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.VerificationHighLevelErrors;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.logging.text.TreeFormatter;

class SimpleTextDependencyVerificationReportRenderer
extends AbstractTextDependencyVerificationReportRenderer {
    private final Set<String> artifacts = new LinkedHashSet<String>();
    private ModuleComponentArtifactIdentifier artifact;

    public SimpleTextDependencyVerificationReportRenderer(Path gradleUserHome, DocumentationRegistry documentationRegistry) {
        super(gradleUserHome, documentationRegistry);
    }

    @Override
    public void startNewSection(String title) {
        this.formatter = new TreeFormatter();
        this.formatter.node("Dependency verification failed for " + title);
    }

    @Override
    public void startArtifactErrors(Runnable action) {
        action.run();
    }

    @Override
    public void startNewArtifact(ModuleComponentArtifactIdentifier key, Runnable action) {
        this.artifact = key;
        action.run();
    }

    @Override
    public void reportFailure(RepositoryAwareVerificationFailure failure) {
        this.artifacts.add(this.artifact.getDisplayName() + " from repository " + failure.getRepositoryName());
    }

    @Override
    public void finish(VerificationHighLevelErrors highLevelErrors) {
        int size = this.artifacts.size();
        if (size == 1) {
            this.formatter.node("One artifact failed verification: " + this.artifacts.iterator().next());
        } else {
            this.formatter.node(this.artifacts.size() + " artifacts failed verification");
            this.formatter.startChildren();
            for (String artifact : this.artifacts) {
                this.formatter.node(artifact);
            }
            this.formatter.endChildren();
        }
        super.finish(highLevelErrors);
    }

    @Override
    public void reportAsMultipleErrors(Runnable action) {
        action.run();
    }
}

