/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.gradle.api.internal.tasks.testing.GroupTestEventReporterInternal;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestEventReporterInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestEventReporter;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class TestEventReporterAsListener
implements TestListenerInternal,
AutoCloseable {
    private final Function<TestDescriptorInternal, GroupTestEventReporterInternal> rootTestReporterCreator;
    private final Map<Object, TestEventReporter> reportersById = new HashMap<Object, TestEventReporter>();

    public TestEventReporterAsListener(Function<TestDescriptorInternal, GroupTestEventReporterInternal> rootTestReporterCreator) {
        this.rootTestReporterCreator = rootTestReporterCreator;
    }

    @Override
    public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
        TestEventReporter reporter;
        if (testDescriptor.getParent() != null) {
            GroupTestEventReporterInternal parentReporter = (GroupTestEventReporterInternal)this.reportersById.get(testDescriptor.getParent().getId());
            reporter = testDescriptor.isComposite() ? parentReporter.reportTestGroupDirectly(testDescriptor) : parentReporter.reportTestDirectly(testDescriptor);
        } else {
            reporter = this.rootTestReporterCreator.apply(testDescriptor);
        }
        reporter.started(Instant.ofEpochMilli(startEvent.getStartTime()));
        this.reportersById.put(testDescriptor.getId(), reporter);
    }

    @Override
    public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
        TestEventReporterInternal reporter = (TestEventReporterInternal)this.reportersById.remove(testDescriptor.getId());
        if (reporter == null) {
            throw new IllegalStateException("No reporter found for test descriptor: " + testDescriptor);
        }
        try {
            if (testResult.getResultType() == null) {
                throw new IllegalArgumentException("Result type is required");
            }
            switch (testResult.getResultType()) {
                case SUCCESS: {
                    reporter.succeeded(Instant.ofEpochMilli(completeEvent.getEndTime()));
                    break;
                }
                case FAILURE: {
                    reporter.failed(Instant.ofEpochMilli(completeEvent.getEndTime()), testResult.getFailures());
                    break;
                }
                case SKIPPED: {
                    reporter.skipped(Instant.ofEpochMilli(completeEvent.getEndTime()), testResult.getAssumptionFailure());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown result type: " + testResult.getResultType());
                }
            }
        }
        finally {
            reporter.close();
        }
    }

    @Override
    public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
        TestEventReporter reporter = this.reportersById.get(testDescriptor.getId());
        if (reporter == null) {
            throw new IllegalStateException("No reporter found for test descriptor: " + testDescriptor);
        }
        reporter.output(Instant.ofEpochMilli(event.getLogTime()), event.getDestination(), event.getMessage());
    }

    @Override
    public void metadata(TestDescriptorInternal testDescriptor, TestMetadataEvent event) {
        TestEventReporter reporter = this.reportersById.get(testDescriptor.getId());
        if (reporter == null) {
            throw new IllegalStateException("No reporter found for test descriptor: " + testDescriptor);
        }
        reporter.metadata(Instant.ofEpochMilli(event.getLogTime()), event.getValues());
    }

    @Override
    public void close() {
        ArrayList<Throwable> allExceptions = new ArrayList<Throwable>();
        for (TestEventReporter reporter : this.reportersById.values()) {
            try {
                reporter.close();
            }
            catch (Throwable t) {
                allExceptions.add(t);
            }
        }
        this.reportersById.clear();
        if (!allExceptions.isEmpty()) {
            throw new DefaultMultiCauseException("Failed to close some test reporters", allExceptions);
        }
    }
}

