// Generated by gmmproc 2.85.0 -- DO NOT MODIFY!
#ifndef _GDKMM_DMABUFFORMATS_H
#define _GDKMM_DMABUFFORMATS_H

#include <gdkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/refptr.h>
#include <glibmm/value.h>
#include <gdk/gdk.h> // For GdkDmabufFormats

namespace Gdk
{
/** %Gdk::DmabufFormats provides information about supported DMA buffer formats.
 *
 * You can query whether a given format is supported with contains()
 * and you can iterate over the list of all supported formats with
 * get_n_formats() and get_format().
 *
 * The list of supported formats is sorted by preference,
 * with the best formats coming first.
 *
 * See Gdk::DmabufTextureBuilder for more information about DMA buffers.
 *
 * Get a %DmabufFormats object with Gdk::Display::get_dmabuf_formats().
 *
 * Note that DMA buffers only exist on Linux.
 *
 * @newin{4,14}
 */
class GDKMM_API DmabufFormats final
{
  // GdkDmabufFormats is registered as a boxed type, but it has custom
  // reference-counting instead of copy/free functions, so we use it via RefPtr.
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = DmabufFormats;
  using BaseObjectType = GdkDmabufFormats;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GdkDmabufFormats*       gobj();

  ///Provides access to the underlying C instance.
  const GdkDmabufFormats* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkDmabufFormats* gobj_copy() const;

  DmabufFormats() = delete;

  // noncopyable
  DmabufFormats(const DmabufFormats&) = delete;
  DmabufFormats& operator=(const DmabufFormats&) = delete;

protected:
  // Do not derive this.  Gdk::DmabufFormats can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
  
  /** Returns the number of formats that the @a formats object
   * contains.
   * 
   * Note that DMA buffers are a Linux concept, so on other
   * platforms, get_n_formats() will
   * always return zero.
   * 
   * @newin{4,14}
   * 
   * @return The number of formats.
   */
  gsize get_n_formats() const;

  /** Gets the fourcc code and modifier for a format.
   *
   * @newin{4,14}
   *
   * @param idx The index of the format to return.
   * @return {fourcc, modifier} The format code and the format modifier.
   */
  std::pair<guint32, guint64> get_format(gsize idx) const;
  

  /** Returns whether a given format is contained in @a formats.
   * 
   * @newin{4,14}
   * 
   * @param fourcc A format code.
   * @param modifier A format modifier.
   * @return <tt>true</tt> if the format specified by the arguments
   * is part of @a formats.
   */
  bool contains(guint32 fourcc, guint64 modifier) const;
  
  /** Returns whether @a formats1 and @a formats2 contain the
   * same dmabuf formats, in the same order.
   * 
   * @newin{4,14}
   * 
   * @param formats2 Another `Gdk::DmabufFormats`.
   * @return <tt>true</tt> if @a formats1 and @a formats2 are equal.
   */
  bool equal(const Glib::RefPtr<const DmabufFormats>& formats2) const;


};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{
// This is needed so Glib::RefPtr<Gdk::DmabufFormats> can be used with
// Glib::Value and _WRAP_PROPERTY in Gdk::Display.
template <>
class GDKMM_API Value<Glib::RefPtr<Gdk::DmabufFormats>> : public ValueBase_Boxed
{
public:
  typedef Glib::RefPtr<Gdk::DmabufFormats> CppType;
  typedef GdkDmabufFormats* CType;

  static GType value_type();

  void set(const CppType& data);
  CppType get() const;
};
} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::DmabufFormats
 */
GDKMM_API
Glib::RefPtr<Gdk::DmabufFormats> wrap(GdkDmabufFormats* object, bool take_copy = false);

} // namespace Glib


#endif /* _GDKMM_DMABUFFORMATS_H */

