// Generated by gmmproc 2.85.0 -- DO NOT MODIFY!
#ifndef _GDKMM_GLTEXTUREBUILDER_H
#define _GDKMM_GLTEXTUREBUILDER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/object.h>
#include <gdkmm/enums.h>
#include <cairomm/region.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkGLTextureBuilder = struct _GdkGLTextureBuilder;
using GdkGLTextureBuilderClass = struct _GdkGLTextureBuilderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class GDKMM_API GLTextureBuilder_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{
class GDKMM_API ColorState;
class GDKMM_API GLContext;
class GDKMM_API Texture;

/** %Gdk::GLTextureBuilder is a buider used to construct Gdk::Texture objects
 * from GL textures.
 *
 * The operation is quite simple: Create a texture builder, set all the necessary
 * properties - keep in mind that property_context(), property_id(),
 * property_width(), and property_height() are mandatory - and then call
 * build() to create the new texture.
 *
 * %Gdk::GLTextureBuilder can be used for quick one-shot construction of
 * textures as well as kept around and reused to construct multiple textures.
 *
 * @newin{4,12}
 */

class GDKMM_API GLTextureBuilder : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = GLTextureBuilder;
  using CppClassType = GLTextureBuilder_Class;
  using BaseObjectType = GdkGLTextureBuilder;
  using BaseClassType = GdkGLTextureBuilderClass;

  // noncopyable
  GLTextureBuilder(const GLTextureBuilder&) = delete;
  GLTextureBuilder& operator=(const GLTextureBuilder&) = delete;

private:  friend class GLTextureBuilder_Class;
  static CppClassType gltexturebuilder_class_;

protected:
  explicit GLTextureBuilder(const Glib::ConstructParams& construct_params);
  explicit GLTextureBuilder(GdkGLTextureBuilder* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  GLTextureBuilder(GLTextureBuilder&& src) noexcept;
  GLTextureBuilder& operator=(GLTextureBuilder&& src) noexcept;

  ~GLTextureBuilder() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkGLTextureBuilder*       gobj()       { return reinterpret_cast<GdkGLTextureBuilder*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkGLTextureBuilder* gobj() const { return reinterpret_cast<GdkGLTextureBuilder*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkGLTextureBuilder* gobj_copy();

private:

   
protected:
  GLTextureBuilder();

public:
  
  static Glib::RefPtr<GLTextureBuilder> create();


  /** Gets the context previously set via set_context() or
   * <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,12}
   * 
   * @return The context.
   */
  Glib::RefPtr<GLContext> get_context();
  
  /** Gets the context previously set via set_context() or
   * <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,12}
   * 
   * @return The context.
   */
  Glib::RefPtr<const GLContext> get_context() const;
  
  /** Sets the context to be used for the texture. This is the context that owns
   * the texture.
   * 
   * The context must be set before calling build().
   * 
   * @newin{4,12}
   * 
   * @param context The context the texture belongs to or <tt>nullptr</tt> to unset.
   */
  void set_context(const Glib::RefPtr<GLContext>& context);

  
  /** Gets the texture id previously set via set_id() or
   * 0 if the id wasn't set.
   * 
   * @newin{4,12}
   * 
   * @return The id.
   */
  guint get_id() const;
  
  /** Sets the texture id of the texture. The texture id must remain unmodified
   * until the texture was finalized. See build()
   * for a longer discussion.
   * 
   * The id must be set before calling build().
   * 
   * @newin{4,12}
   * 
   * @param id The texture id to be used for creating the texture.
   */
  void set_id(guint id);

  
  /** Gets the width previously set via set_width() or
   * 0 if the width wasn't set.
   * 
   * @newin{4,12}
   * 
   * @return The width.
   */
  int get_width() const;
  
  /** Sets the width of the texture.
   * 
   * The width must be set before calling build().
   * 
   * @newin{4,12}
   * 
   * @param width The texture's width or 0 to unset.
   */
  void set_width(int width);

  
  /** Gets the height previously set via set_height() or
   * 0 if the height wasn't set.
   * 
   * @newin{4,12}
   * 
   * @return The height.
   */
  int get_height() const;
  
  /** Sets the height of the texture.
   * 
   * The height must be set before calling build().
   * 
   * @newin{4,12}
   * 
   * @param height The texture's height or 0 to unset.
   */
  void set_height(int height);

  
  /** Gets the format previously set via set_format().
   * 
   * @newin{4,12}
   * 
   * @return The format.
   */
  MemoryFormat get_format() const;
  
  /** Sets the format of the texture. The default is `Gdk::MemoryFormat::R8G8B8A8_PREMULTIPLIED`.
   * 
   * The format is the preferred format the texture data should be downloaded to. The
   * format must be supported by the GL version of property_context().
   * 
   * GDK's texture download code assumes that the format corresponds to the storage
   * parameters of the GL texture in an obvious way. For example, a format of
   * `Gdk::MemoryFormat::R16G16B16A16_PREMULTIPLIED` is expected to be stored as `GL_RGBA16`
   * texture, and `Gdk::MemoryFormat::G8A8` is expected to be stored as `GL_RG8` texture.
   * 
   * Setting the right format is particularly useful when using high bit depth textures
   * to preserve the bit depth, to set the correct value for unpremultiplied textures
   * and to make sure opaque textures are treated as such.
   * 
   * Non-RGBA textures need to have swizzling parameters set up properly to be usable
   * in GSK's shaders.
   * 
   * @newin{4,12}
   * 
   * @param format The texture's format.
   */
  void set_format(MemoryFormat format);

  
  /** Gets whether the texture has a mipmap.
   * 
   * @newin{4,12}
   * 
   * @return Whether the texture has a mipmap.
   */
  bool get_has_mipmap() const;
  
  /** Sets whether the texture has a mipmap. This allows the renderer and other users of the
   * generated texture to use a higher quality downscaling.
   * 
   * Typically, the `glGenerateMipmap` function is used to generate a mimap.
   * 
   * @newin{4,12}
   * 
   * @param has_mipmap Whether the texture has a mipmap.
   */
  void set_has_mipmap(bool has_mipmap =  true);

  
  /** Gets the `Lsync` previously set via set_sync().
   * 
   * @newin{4,12}
   * 
   * @return The `LSync`.
   */
  void* get_sync() const;
  
  /** Sets the GLSync object to use for the texture.
   * 
   * GTK will wait on this object before using the created `Gdk::Texture`.
   * 
   * The `destroy` function that is passed to build()
   * is responsible for freeing the sync object when it is no longer needed.
   * The texture builder does not destroy it and it is the callers
   * responsibility to make sure it doesn't leak.
   * 
   * @newin{4,12}
   * 
   * @param sync The GLSync object.
   */
  void set_sync(void* sync);

  // ColorState is immutable. No need for a non-const get-method.
  
  /** Gets the color state previously set via set_color_state().
   * 
   * @newin{4,16}
   * 
   * @return The color state.
   */
  Glib::RefPtr<ColorState> get_color_state() const;
  
  /** Sets the color state for the texture.
   * 
   * By default, the sRGB colorstate is used. If you don't know what
   * colorstates are, this is probably the right thing.
   * 
   * @newin{4,16}
   * 
   * @param color_state A `Gdk::ColorState`.
   */
  void set_color_state(const Glib::RefPtr<const ColorState>& color_state);

  
  /** Gets the texture previously set via set_update_texture() or
   * <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,12}
   * 
   * @return The texture.
   */
  Glib::RefPtr<Texture> get_update_texture();
  
  /** Gets the texture previously set via set_update_texture() or
   * <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,12}
   * 
   * @return The texture.
   */
  Glib::RefPtr<const Texture> get_update_texture() const;
  
  /** Sets the texture to be updated by this texture. See
   * set_update_region() for an explanation.
   * 
   * @newin{4,12}
   * 
   * @param texture The texture to update.
   */
  void set_update_texture(const Glib::RefPtr<Texture>& texture);

  
  /** Gets the region previously set via set_update_region() or
   * <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,12}
   * 
   * @return The region.
   */
  ::Cairo::RefPtr< ::Cairo::Region> get_update_region();
  
  /** Gets the region previously set via set_update_region() or
   * <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,12}
   * 
   * @return The region.
   */
  ::Cairo::RefPtr<const ::Cairo::Region> get_update_region() const;
  
  /** Sets the region to be updated by this texture. Together with
   * property_update_texture() this describes an
   * update of a previous texture.
   * 
   * When rendering animations of large textures, it is possible that
   * consecutive textures are only updating contents in parts of the texture.
   * It is then possible to describe this update via these two properties,
   * so that GTK can avoid rerendering parts that did not change.
   * 
   * An example would be a screen recording where only the mouse pointer moves.
   * 
   * @newin{4,12}
   * 
   * @param region The region to update.
   */
  void set_update_region(const ::Cairo::RefPtr< ::Cairo::Region>& region);

  /** For instance,
   * void on_gl_texture_released();
   */
  using SlotGLTextureReleased = sigc::slot<void()>;

  
  /** Builds a new `Gdk::Texture` with the values set up in the builder.
   * 
   * The `destroy` function gets called when the returned texture gets released;
   * either when the texture is finalized or by an explicit call to
   * release(). It should release all GL resources associated
   * with the texture, such as the property_id() and the
   * property_sync().
   * 
   * Note that it is a programming error to call this function if any mandatory
   * property has not been set.
   * 
   * It is possible to call this function multiple times to create multiple textures,
   * possibly with changing properties in between.
   * 
   * @newin{4,12}
   * 
   * @param slot Destroy function to be called when the texture is
   * released.
   * @return A newly built `Gdk::Texture`.
   */
  Glib::RefPtr<Texture> build(const SlotGLTextureReleased& slot =  {});

  /** The context owning the texture.
   * 
   * @newin{4,12}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<GLContext> > property_context() ;

/** The context owning the texture.
   * 
   * @newin{4,12}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<GLContext> > property_context() const;

  /** The format when downloading the texture.
   * 
   * @newin{4,12}
   *
   * Default value: Gdk::MemoryFormat::R8G8B8A8_PREMULTIPLIED
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< MemoryFormat > property_format() ;

/** The format when downloading the texture.
   * 
   * @newin{4,12}
   *
   * Default value: Gdk::MemoryFormat::R8G8B8A8_PREMULTIPLIED
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< MemoryFormat > property_format() const;

  /** If the texture has a mipmap.
   * 
   * @newin{4,12}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_mipmap() ;

/** If the texture has a mipmap.
   * 
   * @newin{4,12}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_mipmap() const;

  /** The height of the texture.
   * 
   * @newin{4,12}
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_height() ;

/** The height of the texture.
   * 
   * @newin{4,12}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_height() const;

  /** The texture ID to use.
   * 
   * @newin{4,12}
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_id() ;

/** The texture ID to use.
   * 
   * @newin{4,12}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_id() const;

  //TODO: Is there a better data type than void* in property_sync()?
  //_WRAP_PROPERTY("sync", void*)
  /** The color state of the texture.
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<ColorState> > property_color_state() ;

/** The color state of the texture.
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ColorState> > property_color_state() const;

  /** The update region for property_update_texture().
   * 
   * @newin{4,12}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ::Cairo::RefPtr< ::Cairo::Region> > property_update_region() ;

/** The update region for property_update_texture().
   * 
   * @newin{4,12}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ::Cairo::RefPtr< ::Cairo::Region> > property_update_region() const;

  /** The texture property_update_region() is an update for.
   * 
   * @newin{4,12}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Texture> > property_update_texture() ;

/** The texture property_update_region() is an update for.
   * 
   * @newin{4,12}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Texture> > property_update_texture() const;

  /** The width of the texture.
   * 
   * @newin{4,12}
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_width() ;

/** The width of the texture.
   * 
   * @newin{4,12}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width() const;


  // There are no signals or public vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::GLTextureBuilder
   */
  GDKMM_API
  Glib::RefPtr<Gdk::GLTextureBuilder> wrap(GdkGLTextureBuilder* object, bool take_copy = false);
}


#endif /* _GDKMM_GLTEXTUREBUILDER_H */

