#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-LTS2NYlb1uX1OFFp0jy4wh
key:                  aeson-2.1.2.1-LTS2NYlb1uX1OFFp0jy4wh
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  3ec65f8492ccfac0bb4b8eb249df359d
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-LTS2NYlb1uX1OFFp0jy4wh
depends:
    OneTuple-0.4.2-2tzS8w4U7T42HVCT9nuDQM
    QuickCheck-2.14.3-5M5TotFyqMq9PCRuWSklwe
    attoparsec-0.14.4-EO1k9N7pvB2HEQuv23MWN base-4.17.2.1
    base-compat-batteries-0.13.1-6uaYAbIS0VZ2LV5FLJ7Lxe
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-59PPjdvkGb49zqCFaqVd5N deepseq-1.4.8.0
    dlist-1.0-EcHgAYEoFWBKoiPlM8eS0R exceptions-0.10.5
    generically-0.1.1-C0NswQcFthDI7yXyRUHFGT ghc-prim-0.9.1
    hashable-1.4.4.0-32D8TF68xTpFTCUtV1slOl
    indexed-traversable-0.1.4-FUUuMGYQ6soDzHvrIh7KUw
    primitive-0.9.1.0-EbllCvMUhzBJULOmYBYxU4
    scientific-0.3.8.0-ECM1X4w9aCV1oDTMJMlYIW
    semialign-1.3.1-4sYOVnH4qJxAmTF4Z2Wvmb
    strict-0.5-7C99vBCYlli65jTI6Fs3vh
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-1dWLpfGGnMp1z92GGSzHhJ
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-5dOFIZC1CmTAhvfbVdyrEa time-1.12.2
    time-compat-1.9.7-4GVeL8bcQrEImFNvts2hjc
    unordered-containers-0.2.20-AhSAKQoMQ97FOa03PWrXZ
    uuid-types-1.0.6-FX5ya2kwjt9lCfMKPOVo9
    vector-0.13.2.0-PKWel9ZBueBULxf3GbwPA
    witherable-0.4.2-GjZG5Sn6k9TDX63YCJ2lMR

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

