#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
key:                  aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  012b45f853042cb491ed1a41585c3a15
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
depends:
    OneTuple-0.4.2-E5qfe1kib68CwMHRlpJ9Mf
    QuickCheck-2.15.0.1-I0djFeIgNIwKhHwbhHCf4p
    attoparsec-0.14.4-6kRuW0kw4gG3rg1QrsDffs base-4.17.2.1
    base-compat-batteries-0.13.1-Ah5C1vZQAFcDPuDHW0iUr0
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-6FcTjA3oiTWIvNFQdixCfS deepseq-1.4.8.0
    dlist-1.0-4JevPcHjuIUFMGxCSM81ml exceptions-0.10.5
    generically-0.1.1-LGW1d5l2ALjKDeyX33zyr6 ghc-prim-0.9.1
    hashable-1.4.5.0-DrXzgEMDRcV8gNOMGO5wPZ
    indexed-traversable-0.1.4-CjelN0MuLjgFb4a6UstzaC
    primitive-0.9.1.0-Jxt7FQpUmq1Ffbc4VwJGN5
    scientific-0.3.8.0-BCRNugtxiDS8UMOiZ0ZEsF
    semialign-1.3.1-38xztmCDDENL24lnVzyiHk
    strict-0.5-JrjUHjXQtoFD6aDl0wc8J9
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-AdHnHrpO3sZ2xlsGvlHoPI
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-7h2BB8zQYzzI0zs7FKrs1b time-1.12.2
    time-compat-1.9.7-Lp4yHSXOXnm7NwA0QeuSsu
    unordered-containers-0.2.20-FLM1pZb3BI5FpyNo5sVXNv
    uuid-types-1.0.6-4FBWy54GmK8HdU0HTDUBUB
    vector-0.13.2.0-LmFi28PTaN7DJJszRwFTiC
    witherable-0.4.2-3IvOM55Cfvt7BZpiA7Wzt6

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

