#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG
key:                  aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  35c56bf2776e67e0e1149826fa1c0dea
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG
depends:
    OneTuple-0.4.2-E5qfe1kib68CwMHRlpJ9Mf
    QuickCheck-2.15.0.1-9BbRJGxXLRp2lnC2CpyIBM
    attoparsec-0.14.4-H7aeDSX4mnyDRaYndD48j5 base-4.17.2.1
    base-compat-batteries-0.14.0-IR4H9yfqbfWGXe7JJ58NgS
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-HNyWd7GOMT1FiTSl1XF8N9 deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    generically-0.1.1-8nLcDAwlIf9JWE5yLg57Oq ghc-prim-0.9.1
    hashable-1.4.5.0-JHGJZlFhSc53NK2NYV614f
    indexed-traversable-0.1.4-1JQoS0W1FKXHtvIno5fsGs
    primitive-0.9.1.0-9RF5UPzNfxF3rXGzmAaAQ3
    scientific-0.3.8.0-Ksazu1q4lbv7nBtRDhz1zC
    semialign-1.3.1-HBkjQdw7kpeILvapslklT4
    strict-0.5-JYn57e8hMcL31DH9tSn7RI
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-FjJkVdy1264H7kEs2hJTG7
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-A0xlneEBlhpienL4vlBlr time-1.12.2
    time-compat-1.9.7-IxEQE3wNsG2EerQ6YOPTZG
    unordered-containers-0.2.20-JDDg5JU7nYP5ffg7vR2UZh
    uuid-types-1.0.6-JwDhG2AAhwxL1J85P7XjWi
    vector-0.13.2.0-LerqRcvS8LMBGXOi8GqDsa
    witherable-0.4.2-518gxPIoMi02UeBIHfslOi

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

