#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
key:                  aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  5abd2925eda27d77687b2bf61d2521f6
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
depends:
    OneTuple-0.4.2-lLbDmQ7wy23g5Stri0EUa
    QuickCheck-2.15.0.1-1pOwhmMeliZCxioVyv9M89
    attoparsec-0.14.4-4euoXrooDbuLZe6Xn3rp2d base-4.17.2.1
    base-compat-batteries-0.14.1-HkZsysyrS2w4mLBD1Jzd8W
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-A9Lj2wRKe3aB34hbPZHfZA deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    generically-0.1.1-K0r3uoNMggT4OCQyPtCP8Z ghc-prim-0.9.1
    hashable-1.4.7.0-LvsgkXc0RJl9ehxeji9DTo
    indexed-traversable-0.1.4-2BJBYQqmGPr8tnVTwezaGL
    primitive-0.9.1.0-8f7NBHiHFdgFE3qTf44BEn
    scientific-0.3.8.0-GtjUIC3j80u95XeMq22yYk
    semialign-1.3.1-tLsGVNCzukJsPZeUmyKZR
    strict-0.5-8rgIjbeAooS5grh3KRoRGd
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-AxNUSXCvmUOFZKxidjG0ww
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-9VHMKjOuSzDgeZHveWaOt time-1.12.2
    time-compat-1.9.8-H1u84iZbcOW3rifzxX96y7
    unordered-containers-0.2.20.1-LlrDkEbe6ka5Vid8Nf7fMl
    uuid-types-1.0.6-6rNH1Gm0DBxbogwQQ2CSQ
    vector-0.13.2.0-9W9rHKyBrY08EKASla5WO0
    witherable-0.4.2-IaKW4QXhRdCHPK0JW5h9mi

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

