#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              2.2
visibility:           public
id:                   brick-2.2-BhxQOY8vbN83L7bH2hp8Sf
key:                  brick-2.2-BhxQOY8vbN83L7bH2hp8Sf
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2023
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  77f4d347464ed481ad59703b5b4a5d27
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Parse Brick.Keybindings.Pretty Brick.Main
    Brick.Themes Brick.Types Brick.Util Brick.Widgets.Border
    Brick.Widgets.Border.Style Brick.Widgets.Center Brick.Widgets.Core
    Brick.Widgets.Dialog Brick.Widgets.Edit Brick.Widgets.FileBrowser
    Brick.Widgets.List Brick.Widgets.ProgressBar Brick.Widgets.Table
    Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/brick-2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/brick-2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/brick-2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-2.2-BhxQOY8vbN83L7bH2hp8Sf
depends:
    base-4.17.2.1 bimap-0.5.0-IWHbwOX4mvXJx5V4AZnESK
    bytestring-0.11.5.3 config-ini-0.2.7.0-Ku6YMgs2SPA5dlapnVY4yQ
    containers-0.6.7 data-clist-0.2-1PvsVRpbQNq5UbBAvATarY
    deepseq-1.4.8.0 directory-1.3.7.1 exceptions-0.10.5
    filepath-1.4.2.2 microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2 stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2
    text-zipper-0.13-CUmD2Wdl1yA94qcKHp1WoZ
    unix-compat-0.7.4-F45C0yQb72PB0noYxmBbjG
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS
    vty-6.2-LQ0PYKm9OCG4rLxpqs1ws7
    vty-crossplatform-0.4.0.0-AhFBXAzQp7pG3Q1oMynSk2
    word-wrap-0.5-HDbQ1B6ogKeF21k7CJjC6O

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

