#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bytestring-tree-builder
version:              0.2.7.12
visibility:           public
id:                   bytestring-tree-builder-0.2.7.12-HAf7Y8eIMuG9KsX5xsD2rC
key:                  bytestring-tree-builder-0.2.7.12-HAf7Y8eIMuG9KsX5xsD2rC
license:              MIT
copyright:            (c) 2015, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/bytestring-tree-builder
synopsis:
    A very efficient ByteString builder implementation based on the binary tree

description:
    According to
    <https://github.com/nikita-volkov/bytestring-builders-benchmark the benchmarks>
    this builder implementation beats all the alternatives.
    It is especially well-suited for generating strict bytestrings,
    beating the standard builder by at least the factor of 4.

category:             ByteString
abi:                  2dc48ff654142c92f0c5845c2a463b87
exposed:              True
exposed-modules:      ByteString.TreeBuilder
hidden-modules:
    ByteString.TreeBuilder.Poker ByteString.TreeBuilder.Prelude
    ByteString.TreeBuilder.Tree

import-dirs:
    /usr/lib/ghc-9.4.8/site-local/bytestring-tree-builder-0.2.7.12

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/bytestring-tree-builder-0.2.7.12

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/bytestring-tree-builder-0.2.7.12

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bytestring-tree-builder
hs-libraries:         HSbytestring-tree-builder-0.2.7.12-HAf7Y8eIMuG9KsX5xsD2rC
depends:              base-4.17.2.1 bytestring-0.11.5.3 text-2.0.2
haddock-interfaces:
    /usr/share/doc/haskell-bytestring-tree-builder/html/bytestring-tree-builder.haddock

haddock-html:         /usr/share/doc/haskell-bytestring-tree-builder/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

