#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 chimera
version:              0.4.1.0
visibility:           public
id:                   chimera-0.4.1.0-J573v3P54zPJZoCHNz24xB
key:                  chimera-0.4.1.0-J573v3P54zPJZoCHNz24xB
license:              BSD-3-Clause
copyright:            2017-2019 Bodigrim
maintainer:           andrew.lelechenko@gmail.com
author:               Bodigrim
homepage:             https://github.com/Bodigrim/chimera#readme
synopsis:
    Lazy infinite streams with O(1) indexing and applications for memoization

description:
    There are plenty of memoizing libraries on Hackage, but they
    usually fall into two categories:

    * Store cache as a flat array, enabling us
    to obtain cached values in O(1) time, which is nice.
    The drawback is that one must specify the size
    of the array beforehand,
    limiting an interval of inputs,
    and actually allocate it at once.
    * Store cache as a lazy binary tree.
    Thanks to laziness, one can freely use the full range of inputs.
    The drawback is that obtaining values from a tree
    takes logarithmic time and is unfriendly to CPU cache,
    which kinda defeats the purpose.

    This package intends to tackle both issues,
    providing a data type '\''Chimera'\'' for
    lazy infinite compact streams with cache-friendly O(1) indexing.

    Additional features include:

    * memoization of recursive functions and recurrent sequences,
    * memoization of functions of several, possibly signed arguments,
    * efficient memoization of boolean predicates.

category:             Data
abi:                  daaa42c7e5dae5e9636ad307bb8426ab
exposed:              True
exposed-modules:
    Data.Chimera Data.Chimera.ContinuousMapping
    Data.Chimera.WheelMapping

hidden-modules:
    Data.Chimera.Compat Data.Chimera.FromIntegral Data.Chimera.Internal
    Data.Chimera.Memoize

import-dirs:          /usr/lib/ghc-9.6.6/site-local/chimera-0.4.1.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/chimera-0.4.1.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/chimera-0.4.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-chimera
hs-libraries:         HSchimera-0.4.1.0-J573v3P54zPJZoCHNz24xB
depends:
    adjunctions-4.4.3-D8YpGfalO39EkJzU4r4vuU base-4.18.2.1
    distributive-0.6.2.1-H63qUQ2uXaJJr9jbpjdPnD
    infinite-list-0.1.2-C73vonjADlK8b6GAAOqxch mtl-2.3.1
    primitive-0.9.1.0-5oPemL25pV0IilCVm0ELcB transformers-0.6.1.0
    vector-0.13.2.0-6vtrErFI1tV1Z02auPMCSS

haddock-interfaces:   /usr/share/doc/haskell-chimera/html/chimera.haddock
haddock-html:         /usr/share/doc/haskell-chimera/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

