#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.16.6
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.16.6-CH6Zje2CZiZJTBwPpZGY5L-haskell-ci-internal

key:
    haskell-ci-0.16.6-CH6Zje2CZiZJTBwPpZGY5L-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  58c3770cec05da397cbafe4be9546f74
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cabal HaskellCI.Cli
    HaskellCI.Compiler HaskellCI.Config HaskellCI.Config.Components
    HaskellCI.Config.ConstraintSet HaskellCI.Config.CopyFields
    HaskellCI.Config.Docspec HaskellCI.Config.Doctest
    HaskellCI.Config.Dump HaskellCI.Config.Empty HaskellCI.Config.Folds
    HaskellCI.Config.HLint HaskellCI.Config.Installed
    HaskellCI.Config.Jobs HaskellCI.Config.PackageScope
    HaskellCI.Config.Ubuntu HaskellCI.Config.Validity
    HaskellCI.Diagnostics HaskellCI.Error HaskellCI.Ghcup
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.16.6-CH6Zje2CZiZJTBwPpZGY5L-haskell-ci-internal

depends:
    Cabal-syntax-3.8.1.0 HsYAML-0.2.1.5-GrffzjZPcckGNyHHcPPm69
    ShellCheck-0.11.0-1sSJpKVdUT35ofbvoXOTVg
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm
    attoparsec-0.14.4-8oph4y3j0I1GXQUqU3wi8s base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz
    base16-bytestring-1.0.2.0-FCpQxPpZ6OtJjyjiCnnSOC binary-0.8.9.1
    bytestring-0.11.5.3
    cabal-install-parsers-0.6-6Kt9r9gWT8V7haotEzpozC containers-0.6.7
    cryptohash-sha256-0.11.102.1-9pIZgwpD2w9CKxv3QLViI9 deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    generic-lens-lite-0.1.1-fdAG00wdys4njg4MryBwd
    indexed-traversable-0.1.4-7gBVHmZFzpQ83JoiKc0FfD
    indexed-traversable-instances-0.1.2-8VEy9BHeErIJdI5GQlmOtj
    ini-0.4.2-CFXB09kJgWwA8scw1nCG4F
    lattices-2.2.1-HCux5GIMKIOr5F8SOvfgZ mtl-2.2.2
    network-uri-2.6.4.2-60V3uLcyBv8HHhnYdb8knn
    optparse-applicative-0.18.1.0-Fys7kMiK5mr3sU6DxR5vVs
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.18.0
    temporary-1.3-KbjBnRExPZiB3fvyB84Pcu text-2.0.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    zinza-0.2.1-BPQafFScxRH6S3dBVIl9CM

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

