#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-prelude
version:              1.8.2
visibility:           public
id:                   clash-prelude-1.8.2-LrjO7QiGU6T1lLOptL7qni
key:                  clash-prelude-1.8.2-LrjO7QiGU6T1lLOptL7qni
license:              BSD-2-Clause
copyright:
    Copyright © 2013-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.,
    2021-2023, QBayLogic B.V.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - Prelude library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Prelude library containing datatypes and functions for circuit design

    To use the library:

    * Import "Clash.Prelude"

    * Alternatively, if you want to explicitly route clock and reset ports,
    for more straightforward multi-clock designs, you can import the
    "Clash.Explicit.Prelude" module. Note that you should not import
    "Clash.Prelude" and "Clash.Explicit.Prelude" at the same time as they
    have overlapping definitions.

    A preliminary version of a tutorial can be found in "Clash.Tutorial", for a
    general overview of the library you should however check out "Clash.Prelude".
    Some circuit examples can be found in "Clash.Examples".

category:             Hardware
abi:                  1f385a2306ae3b43b41204d456fcd7fa
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation
    Clash.Annotations.BitRepresentation.Deriving
    Clash.Annotations.BitRepresentation.Internal
    Clash.Annotations.BitRepresentation.Util
    Clash.Annotations.Primitive Clash.Annotations.SynthesisAttributes
    Clash.Annotations.TH Clash.Annotations.TopEntity
    Clash.Class.AutoReg Clash.Class.AutoReg.Internal
    Clash.Class.BitPack Clash.Class.BitPack.BitIndex
    Clash.Class.BitPack.BitReduction Clash.Class.BitPack.Internal
    Clash.Class.BitPack.Internal.TH Clash.Class.Counter
    Clash.Class.Counter.Internal Clash.Class.Counter.TH Clash.Class.Exp
    Clash.Class.HasDomain Clash.Class.HasDomain.CodeGen
    Clash.Class.HasDomain.Common Clash.Class.HasDomain.HasSingleDomain
    Clash.Class.HasDomain.HasSpecificDomain Clash.Class.Num
    Clash.Class.Parity Clash.Class.Resize Clash.Clocks Clash.Examples
    Clash.Examples.Internal Clash.Explicit.BlockRam
    Clash.Explicit.BlockRam.Blob Clash.Explicit.BlockRam.File
    Clash.Explicit.BlockRam.Internal Clash.Explicit.BlockRam.Model
    Clash.Explicit.DDR Clash.Explicit.Mealy Clash.Explicit.Moore
    Clash.Explicit.Prelude Clash.Explicit.Prelude.Safe
    Clash.Explicit.RAM Clash.Explicit.ROM Clash.Explicit.ROM.Blob
    Clash.Explicit.ROM.File Clash.Explicit.Reset Clash.Explicit.Signal
    Clash.Explicit.Signal.Delayed Clash.Explicit.SimIO
    Clash.Explicit.Synchronizer Clash.Explicit.Testbench
    Clash.Explicit.Verification Clash.HaskellPrelude Clash.Hidden
    Clash.Intel.ClockGen Clash.Intel.DDR Clash.Magic Clash.NamedTypes
    Clash.Num.Erroring Clash.Num.Overflowing Clash.Num.Saturating
    Clash.Num.Wrapping Clash.Num.Zeroing Clash.Prelude
    Clash.Prelude.BlockRam Clash.Prelude.BlockRam.Blob
    Clash.Prelude.BlockRam.File Clash.Prelude.DataFlow
    Clash.Prelude.Mealy Clash.Prelude.Moore Clash.Prelude.RAM
    Clash.Prelude.ROM Clash.Prelude.ROM.Blob Clash.Prelude.ROM.File
    Clash.Prelude.Safe Clash.Prelude.Testbench Clash.Promoted.Nat
    Clash.Promoted.Nat.Literals Clash.Promoted.Nat.TH
    Clash.Promoted.Nat.Unsafe Clash.Promoted.Symbol Clash.Signal
    Clash.Signal.BiSignal Clash.Signal.Bundle Clash.Signal.Delayed
    Clash.Signal.Delayed.Bundle Clash.Signal.Delayed.Internal
    Clash.Signal.Internal Clash.Signal.Internal.Ambiguous
    Clash.Signal.Trace Clash.Sized.BitVector Clash.Sized.Fixed
    Clash.Sized.Index Clash.Sized.Internal.BitVector
    Clash.Sized.Internal.Index Clash.Sized.Internal.Mod
    Clash.Sized.Internal.Signed Clash.Sized.Internal.Unsigned
    Clash.Sized.RTree Clash.Sized.Signed Clash.Sized.Unsigned
    Clash.Sized.Vector Clash.Sized.Vector.ToTuple
    Clash.Sized.Vector.ToTuple.TH Clash.Tutorial Clash.Verification
    Clash.Verification.DSL Clash.Verification.Internal Clash.XException
    Clash.XException.Internal Clash.XException.MaybeX
    Clash.XException.TH Clash.Xilinx.ClockGen Clash.Xilinx.DDR

hidden-modules:
    Clash.Class.AutoReg.Instances Clash.Clocks.Internal Clash.CPP
    Clash.Signal.Bundle.Internal Clash.Sized.Internal
    Language.Haskell.TH.Compat Paths_clash_prelude

import-dirs:          /usr/lib/ghc-9.4.8/site-local/clash-prelude-1.8.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/clash-prelude-1.8.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/clash-prelude-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-prelude
hs-libraries:         HSclash-prelude-1.8.2-LrjO7QiGU6T1lLOptL7qni
depends:
    QuickCheck-2.15.0.1-BieguRabt0yBi6koHkfIn1 array-0.5.4.0
    arrows-0.4.4.2-3zlaUK3YNw9EGGa356B5S base-4.17.2.1 binary-0.8.9.1
    bytestring-0.11.5.3 constraints-0.14.2-BzosEYfLBtf19uZHft3bw9
    containers-0.6.7 data-binary-ieee754-0.4.4-3K4wyZ8KRa1CgKftL8GYsk
    data-default-class-0.1.2.2-2EcHBs5cfSFLku8331ZnRi deepseq-1.4.8.0
    extra-1.7.16-FVFc4gt4avs4Z4Fwytd6v6 ghc-bignum-1.3 ghc-prim-0.9.1
    ghc-typelits-extra-0.4.8-EfEocqs7em2KGJbmU1XDpd
    ghc-typelits-knownnat-0.7.12-GNnwpZ8dSbr3pYu3ei8BtX
    ghc-typelits-natnormalise-0.7.11-4LQQO7nnVuGDiLs8fBmoOI
    half-0.3.3-BJIdkiUdV2NFpv0HYTn0eY
    hashable-1.4.6.0-Bdyeh8ev81I2bBqnptAVUL
    infinite-list-0.1.2-KKRkluaB2TjH078QcUtFC0
    lens-5.3.2-3lnPesktvu71I24tA5AXig mtl-2.2.2
    recursion-schemes-5.2.3-Qfu6nnS3iUIrqydOp678P
    reflection-2.1.9-9QBsCaXxc9FBcf5AXJxZGV
    singletons-3.0.4-5pDsUnwe3c7FZQt4Yt8MEN
    string-interpolate-0.3.4.0-IqindZuSqvw8CfRr3ahsQm
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    th-lift-0.8.6-HRVeiGNnDxNElRy2LmdExl
    th-orphans-0.13.16-9zpHCWN6DyP5maySt9GDRw time-1.12.2
    transformers-0.5.6.2 type-errors-0.2.0.2-K6koWJOsACw8cBkGtg9i9I
    uniplate-1.6.13-CJ0oCvoijnU13momfUMYNw
    vector-0.13.2.0-JPy5pohpq8EDknIfFhMz6E

haddock-interfaces:
    /usr/share/doc/haskell-clash-prelude/html/clash-prelude.haddock

haddock-html:         /usr/share/doc/haskell-clash-prelude/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

