#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptonite
version:              0.30
visibility:           public
id:                   cryptonite-0.30-GDXPd4Usip610py58lI1cm
key:                  cryptonite-0.30-GDXPd4Usip610py58lI1cm
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/haskell-crypto/cryptonite
synopsis:             Cryptography Primitives sink
description:
    A repository of cryptographic primitives.

    * Symmetric ciphers: AES, DES, 3DES, CAST5, Blowfish, Twofish, Camellia, RC4, Salsa, XSalsa, ChaCha.

    * Hash: SHA1, SHA2, SHA3, SHAKE, MD2, MD4, MD5, Keccak, Skein, Ripemd, Tiger, Whirlpool, Blake2

    * MAC: HMAC, KMAC, Poly1305

    * Asymmetric crypto: DSA, RSA, DH, ECDH, ECDSA, ECC, Curve25519, Curve448, Ed25519, Ed448

    * Key Derivation Function: PBKDF2, Scrypt, HKDF, Argon2, BCrypt, BCryptPBKDF

    * Cryptographic Random generation: System Entropy, Deterministic Random Generator

    * Data related: Anti-Forensic Information Splitter (AFIS)

    If anything cryptographic related is missing from here, submit
    a pull request to have it added. This package strives to be a
    cryptographic kitchen sink that provides cryptography for everyone.

    Evaluate the security related to your requirements before using.

    Read "Crypto.Tutorial" for a quick start guide.

category:             Cryptography
abi:                  d72522aa92cfc6c36268e6de84e6e3d0
exposed:              True
exposed-modules:
    Crypto.Cipher.AES Crypto.Cipher.AESGCMSIV Crypto.Cipher.Blowfish
    Crypto.Cipher.CAST5 Crypto.Cipher.Camellia Crypto.Cipher.ChaCha
    Crypto.Cipher.ChaChaPoly1305 Crypto.Cipher.DES Crypto.Cipher.RC4
    Crypto.Cipher.Salsa Crypto.Cipher.TripleDES Crypto.Cipher.Twofish
    Crypto.Cipher.Types Crypto.Cipher.Utils Crypto.Cipher.XSalsa
    Crypto.ConstructHash.MiyaguchiPreneel Crypto.Data.AFIS
    Crypto.Data.Padding Crypto.ECC Crypto.ECC.Edwards25519 Crypto.Error
    Crypto.Hash Crypto.Hash.Algorithms Crypto.Hash.IO Crypto.KDF.Argon2
    Crypto.KDF.BCrypt Crypto.KDF.BCryptPBKDF Crypto.KDF.HKDF
    Crypto.KDF.PBKDF2 Crypto.KDF.Scrypt Crypto.MAC.CMAC Crypto.MAC.HMAC
    Crypto.MAC.KMAC Crypto.MAC.Poly1305 Crypto.Number.Basic
    Crypto.Number.F2m Crypto.Number.Generate
    Crypto.Number.ModArithmetic Crypto.Number.Nat Crypto.Number.Prime
    Crypto.Number.Serialize Crypto.Number.Serialize.Internal
    Crypto.Number.Serialize.Internal.LE Crypto.Number.Serialize.LE
    Crypto.OTP Crypto.PubKey.Curve25519 Crypto.PubKey.Curve448
    Crypto.PubKey.DH Crypto.PubKey.DSA Crypto.PubKey.ECC.DH
    Crypto.PubKey.ECC.ECDSA Crypto.PubKey.ECC.Generate
    Crypto.PubKey.ECC.P256 Crypto.PubKey.ECC.Prim
    Crypto.PubKey.ECC.Types Crypto.PubKey.ECDSA Crypto.PubKey.ECIES
    Crypto.PubKey.Ed25519 Crypto.PubKey.Ed448 Crypto.PubKey.EdDSA
    Crypto.PubKey.MaskGenFunction Crypto.PubKey.RSA
    Crypto.PubKey.RSA.OAEP Crypto.PubKey.RSA.PKCS15
    Crypto.PubKey.RSA.PSS Crypto.PubKey.RSA.Prim
    Crypto.PubKey.RSA.Types Crypto.PubKey.Rabin.Basic
    Crypto.PubKey.Rabin.Modified Crypto.PubKey.Rabin.OAEP
    Crypto.PubKey.Rabin.RW Crypto.PubKey.Rabin.Types Crypto.Random
    Crypto.Random.Entropy Crypto.Random.Entropy.Unsafe
    Crypto.Random.EntropyPool Crypto.Random.Types Crypto.System.CPU
    Crypto.Tutorial

hidden-modules:
    Crypto.Cipher.AES.Primitive Crypto.Cipher.Blowfish.Box
    Crypto.Cipher.Blowfish.Primitive Crypto.Cipher.CAST5.Primitive
    Crypto.Cipher.Camellia.Primitive Crypto.Cipher.DES.Primitive
    Crypto.Cipher.Twofish.Primitive Crypto.Cipher.Types.AEAD
    Crypto.Cipher.Types.Base Crypto.Cipher.Types.Block
    Crypto.Cipher.Types.GF Crypto.Cipher.Types.Stream
    Crypto.Cipher.Types.Utils Crypto.Error.Types Crypto.Number.Compat
    Crypto.Hash.Types Crypto.Hash.Blake2 Crypto.Hash.Blake2s
    Crypto.Hash.Blake2sp Crypto.Hash.Blake2b Crypto.Hash.Blake2bp
    Crypto.Hash.SHA1 Crypto.Hash.SHA224 Crypto.Hash.SHA256
    Crypto.Hash.SHA384 Crypto.Hash.SHA512 Crypto.Hash.SHA512t
    Crypto.Hash.SHA3 Crypto.Hash.SHAKE Crypto.Hash.Keccak
    Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
    Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
    Crypto.Hash.Tiger Crypto.Hash.Whirlpool
    Crypto.Random.Entropy.Source Crypto.Random.Entropy.Backend
    Crypto.Random.ChaChaDRG Crypto.Random.SystemDRG
    Crypto.Random.Probabilistic Crypto.PubKey.Internal
    Crypto.PubKey.ElGamal Crypto.ECC.Simple.Types
    Crypto.ECC.Simple.Prim Crypto.Internal.Builder
    Crypto.Internal.ByteArray Crypto.Internal.Compat
    Crypto.Internal.CompatPrim Crypto.Internal.DeepSeq
    Crypto.Internal.Imports Crypto.Internal.Nat Crypto.Internal.Words
    Crypto.Internal.WordArray Crypto.Random.Entropy.RDRand
    Crypto.Random.Entropy.Unix

import-dirs:          /usr/lib/ghc-9.6.6/site-local/cryptonite-0.30
library-dirs:         /usr/lib/ghc-9.6.6/site-local/cryptonite-0.30
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/cryptonite-0.30
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cryptonite
hs-libraries:         HScryptonite-0.30-GDXPd4Usip610py58lI1cm
extra-libraries:      pthread
depends:
    base-4.18.2.1 basement-0.0.16-HvTgG10TboKKpCgs2TlMDx
    bytestring-0.11.5.3 deepseq-1.4.8.1 ghc-prim-0.10.0 integer-gmp-1.1
    memory-0.18.0-6zo36PbRecTK4fqbBnx0f5

haddock-interfaces:   /usr/share/doc/haskell-cryptonite/html/cryptonite.haddock
haddock-html:         /usr/share/doc/haskell-cryptonite/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

