#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptonite-conduit
version:              0.2.2
visibility:           public
id:                   cryptonite-conduit-0.2.2-IQhRrOZw8AZCbqAcNY8tmA
key:                  cryptonite-conduit-0.2.2-IQhRrOZw8AZCbqAcNY8tmA
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/haskell-crypto/cryptonite-conduit
synopsis:             cryptonite conduit
description:
    Conduit bridge for cryptonite

    For now only provide a conduit version for hash and hmac, but
    with contribution, this could provide cipher conduits too,
    and probably other things.

category:             Cryptography, Conduit
abi:                  d0993d2f60ed67f7ac065c34b3c69e2b
exposed:              True
exposed-modules:
    Crypto.Cipher.ChaChaPoly1305.Conduit Crypto.Hash.Conduit
    Crypto.MAC.HMAC.Conduit Crypto.PubKey.ECIES.Conduit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cryptonite-conduit
hs-libraries:         HScryptonite-conduit-0.2.2-IQhRrOZw8AZCbqAcNY8tmA
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    conduit-1.3.6.1-8EwOhhDv3r5EX0bCaWMPRW
    conduit-extra-1.3.8-5wj2QtagE3YHzOewcAu6yq
    cryptonite-0.30-BivVM1upDLN4vtK2YTsF3D exceptions-0.10.5
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    resourcet-1.2.6-1DDiq5XD7CWDw9CwnQya4j transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-cryptonite-conduit/html/cryptonite-conduit.haddock

haddock-html:         /usr/share/doc/haskell-cryptonite-conduit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

