#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-dns-z-dns-internal
version:              4.1.1
package-name:         dns
lib-name:             dns-internal
id:                   dns-4.1.1-LQHCSK0JaYb2L4jAfhiXyh-dns-internal
key:                  dns-4.1.1-LQHCSK0JaYb2L4jAfhiXyh-dns-internal
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Kazu Yamamoto <kazu@iij.ad.jp>
synopsis:             DNS library in Haskell
description:
    A thread-safe DNS library for both clients and servers written
    in pure Haskell.

category:             Network
abi:                  15e2cc5e8524dd85476113c70bc01147
exposed-modules:
    Network.DNS.Base32Hex Network.DNS.Decode.Internal
    Network.DNS.Decode.Parsers Network.DNS.Encode.Builders
    Network.DNS.Encode.Internal Network.DNS.Imports Network.DNS.Memo
    Network.DNS.Resolver.Internal Network.DNS.StateBinary
    Network.DNS.Types.Internal Network.DNS.Types.Resolver

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dns-4.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dns-4.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dns-4.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-dns
hs-libraries:         HSdns-4.1.1-LQHCSK0JaYb2L4jAfhiXyh-dns-internal
depends:
    array-0.5.4.0 async-2.2.5-9OoNXaJHjfh1odoyocMP2h
    attoparsec-0.14.4-4kZjCdGgUdQ9XykEL1OaXf
    auto-update-0.1.6-IPReOllVJUUEXDbKduBovj base-4.17.2.1
    base16-bytestring-1.0.2.0-8KOr0OVfDkD2ATl4yj4Mhp
    base64-bytestring-1.2.1.0-L7UKPnwJMRGuk8q2bdjAR bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4gOYP47XUTf2S4ZStIaMwN containers-0.6.7
    cryptonite-0.30-CjCjILhZEuQLAyDxkDCVop
    hourglass-0.2.12-9gXszDTBD7M9Rbhsd0cW2C
    iproute-1.7.15-9S4uUd2pVt7Ci5U2ORT3Bl mtl-2.2.2
    network-3.1.4.0-Lt9YSaQDSdWKRzslp3ePNQ
    psqueues-0.2.8.2-G0AbkVujDR9HdAUh6GDmR6

haddock-interfaces:   /usr/share/doc/haskell-dns/html/dns.haddock
haddock-html:         /usr/share/doc/haskell-dns/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dns
version:              4.1.1
visibility:           public
id:                   dns-4.1.1-2rLrJ0nbjFpJLDAt6dv2i7
key:                  dns-4.1.1-2rLrJ0nbjFpJLDAt6dv2i7
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Kazu Yamamoto <kazu@iij.ad.jp>
synopsis:             DNS library in Haskell
description:
    A thread-safe DNS library for both clients and servers written
    in pure Haskell.

category:             Network
abi:                  13ef3833e12a0aa856cc7f5fc2d81c15
exposed:              True
exposed-modules:
    Network.DNS Network.DNS.Decode Network.DNS.Encode Network.DNS.IO
    Network.DNS.Lookup Network.DNS.LookupRaw Network.DNS.Resolver
    Network.DNS.Types Network.DNS.Utils

hidden-modules:       Network.DNS.Transport
import-dirs:          /usr/lib/ghc-9.4.8/site-local/dns-4.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dns-4.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dns-4.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-dns
hs-libraries:         HSdns-4.1.1-2rLrJ0nbjFpJLDAt6dv2i7
depends:
    array-0.5.4.0 async-2.2.5-9OoNXaJHjfh1odoyocMP2h
    attoparsec-0.14.4-4kZjCdGgUdQ9XykEL1OaXf
    auto-update-0.1.6-IPReOllVJUUEXDbKduBovj base-4.17.2.1
    base16-bytestring-1.0.2.0-8KOr0OVfDkD2ATl4yj4Mhp
    base64-bytestring-1.2.1.0-L7UKPnwJMRGuk8q2bdjAR bytestring-0.11.5.3
    containers-0.6.7 cryptonite-0.30-CjCjILhZEuQLAyDxkDCVop
    dns-4.1.1-LQHCSK0JaYb2L4jAfhiXyh-dns-internal
    hourglass-0.2.12-9gXszDTBD7M9Rbhsd0cW2C
    iproute-1.7.15-9S4uUd2pVt7Ci5U2ORT3Bl mtl-2.2.2
    network-3.1.4.0-Lt9YSaQDSdWKRzslp3ePNQ
    psqueues-0.2.8.2-G0AbkVujDR9HdAUh6GDmR6

haddock-interfaces:   /usr/share/doc/haskell-dns/html/dns.haddock
haddock-html:         /usr/share/doc/haskell-dns/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

