#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 EdisonCore
version:              1.3.3.2
visibility:           public
id:                   EdisonCore-1.3.3.2-5vgOKlZJDqbCdhn9o99DZG
key:                  EdisonCore-1.3.3.2-5vgOKlZJDqbCdhn9o99DZG
license:              MIT
maintainer:           robdockins AT fastmail DOT fm
author:               Chris Okasaki
stability:            Stable
homepage:             https://github.com/robdockins/edison
synopsis:
    A library of efficient, purely-functional data structures (Core Implementations)

description:
    This package provides the core Edison data structure implementations,
    including multiple sequence, set, bag, and finite map concrete
    implementations with various performance characteristics. The
    implementations in this package have no dependencies other than those
    commonly bundled with Haskell compilers.

category:             Data Structures
abi:                  f504d047f79d5d9778eb1cb8aebce55c
exposed:              True
exposed-modules:
    Data.Edison.Assoc.AssocList Data.Edison.Assoc.Defaults
    Data.Edison.Assoc.PatriciaLoMap Data.Edison.Assoc.StandardMap
    Data.Edison.Assoc.TernaryTrie Data.Edison.Coll.Defaults
    Data.Edison.Coll.EnumSet Data.Edison.Coll.LazyPairingHeap
    Data.Edison.Coll.LeftistHeap Data.Edison.Coll.MinHeap
    Data.Edison.Coll.SkewHeap Data.Edison.Coll.SplayHeap
    Data.Edison.Coll.StandardSet Data.Edison.Coll.UnbalancedSet
    Data.Edison.Concrete.FingerTree Data.Edison.Seq.BankersQueue
    Data.Edison.Seq.BinaryRandList Data.Edison.Seq.BraunSeq
    Data.Edison.Seq.Defaults Data.Edison.Seq.FingerSeq
    Data.Edison.Seq.JoinList Data.Edison.Seq.MyersStack
    Data.Edison.Seq.RandList Data.Edison.Seq.RevSeq
    Data.Edison.Seq.SimpleQueue Data.Edison.Seq.SizedSeq

import-dirs:          /usr/lib/ghc-9.4.8/site-local/EdisonCore-1.3.3.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/EdisonCore-1.3.3.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/EdisonCore-1.3.3.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-edisoncore
hs-libraries:         HSEdisonCore-1.3.3.2-5vgOKlZJDqbCdhn9o99DZG
depends:
    EdisonAPI-1.3.3.2-2mD4dBWxvUBHilR6ZGP27D
    QuickCheck-2.14.3-CpTyyGCQ8vELJYAkeHIgu4 array-0.5.4.0
    base-4.17.2.1 containers-0.6.7

haddock-interfaces:   /usr/share/doc/haskell-edisoncore/html/EdisonCore.haddock
haddock-html:         /usr/share/doc/haskell-edisoncore/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

