#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ghc-typelits-knownnat
version:              0.7.12
visibility:           public
id:                   ghc-typelits-knownnat-0.7.12-AeWEisjwU6nDqfy2Rb0Atl
key:                  ghc-typelits-knownnat-0.7.12-AeWEisjwU6nDqfy2Rb0Atl
license:              BSD-2-Clause
copyright:
    Copyright © 2016     , University of Twente,
    2017-2018, QBayLogic B.V.,
    2017     , Google Inc.

maintainer:           christiaan.baaij@gmail.com
author:               Christiaan Baaij
homepage:             http://clash-lang.org/
synopsis:             Derive KnownNat constraints from other KnownNat constraints
description:
    A type checker plugin for GHC that can derive \"complex\" @KnownNat@
    constraints from other simple/variable @KnownNat@ constraints. i.e. without
    this plugin, you must have both a @KnownNat n@ and a @KnownNat (n+2)@
    constraint in the type signature of the following function:

    @
    f :: forall n . (KnownNat n, KnownNat (n+2)) => Proxy n -> Integer
    f _ = natVal (Proxy :: Proxy n) + natVal (Proxy :: Proxy (n+2))
    @

    Using the plugin you can omit the @KnownNat (n+2)@ constraint:

    @
    f :: forall n . KnownNat n => Proxy n -> Integer
    f _ = natVal (Proxy :: Proxy n) + natVal (Proxy :: Proxy (n+2))
    @

    The plugin can derive @KnownNat@ constraints for types consisting of:

    * Type variables, when there is a corresponding @KnownNat@ constraint

    * Type-level naturals

    * Applications of the arithmetic expression: +,-,*,^

    * Type functions, when there is either:

    1. a matching given @KnownNat@ constraint; or

    2. a corresponding @KnownNat\<N\>@ instance for the type function

    To use the plugin, add the

    @
    OPTIONS_GHC -fplugin GHC.TypeLits.KnownNat.Solver
    @

    Pragma to the header of your file.

category:             Type System
abi:                  bc9f294f5db65ebd1cc1b794405f61dc
exposed:              True
exposed-modules:      GHC.TypeLits.KnownNat GHC.TypeLits.KnownNat.Solver
hidden-modules:       GHC.TypeLits.KnownNat.TH
import-dirs:          /usr/lib/ghc-9.6.6/site-local/ghc-typelits-knownnat-0.7.12
library-dirs:         /usr/lib/ghc-9.6.6/site-local/ghc-typelits-knownnat-0.7.12
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/ghc-typelits-knownnat-0.7.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ghc-typelits-knownnat
hs-libraries:         HSghc-typelits-knownnat-0.7.12-AeWEisjwU6nDqfy2Rb0Atl
depends:
    base-4.18.2.1 ghc-9.6.6 ghc-prim-0.10.0
    ghc-tcplugins-extra-0.5-Gk013ZGNPeb6zZ5XpIVmns
    ghc-typelits-natnormalise-0.7.11-FJGDPj7wdZrB3v973TYHBL
    template-haskell-2.20.0.0 transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-ghc-typelits-knownnat/html/ghc-typelits-knownnat.haddock

haddock-html:         /usr/share/doc/haskell-ghc-typelits-knownnat/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

