#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 happstack-server
version:              7.9.3
visibility:           public
id:                   happstack-server-7.9.3-AWqQsKnqvBuEE3VepbIVri
key:                  happstack-server-7.9.3-AWqQsKnqvBuEE3VepbIVri
license:              BSD-3-Clause
maintainer:           Happstack team <happs@googlegroups.com>
author:               Happstack team, HAppS LLC
homepage:             http://happstack.com
synopsis:             Web related tools and services.
description:
    Happstack Server provides an HTTP server and a rich set of functions for routing requests, handling query parameters, generating responses, working with cookies, serving files, and more. For in-depth documentation see the Happstack Crash Course <http://happstack.com/docs/crashcourse/index.html>

category:             Web, Happstack
abi:                  68496eb502c86e724b97645c534d5937
exposed:              True
exposed-modules:
    Happstack.Server Happstack.Server.Auth Happstack.Server.Compression
    Happstack.Server.Cookie Happstack.Server.Error
    Happstack.Server.FileServe
    Happstack.Server.FileServe.BuildingBlocks Happstack.Server.I18N
    Happstack.Server.Internal.Compression
    Happstack.Server.Internal.Cookie Happstack.Server.Internal.Handler
    Happstack.Server.Internal.Listen
    Happstack.Server.Internal.LogFormat
    Happstack.Server.Internal.LowLevel
    Happstack.Server.Internal.MessageWrap
    Happstack.Server.Internal.Monads
    Happstack.Server.Internal.Multipart
    Happstack.Server.Internal.RFC822Headers
    Happstack.Server.Internal.Socket
    Happstack.Server.Internal.TimeoutIO
    Happstack.Server.Internal.TimeoutManager
    Happstack.Server.Internal.TimeoutSocket
    Happstack.Server.Internal.Types Happstack.Server.Monads
    Happstack.Server.Response Happstack.Server.Routing
    Happstack.Server.RqData Happstack.Server.SURI
    Happstack.Server.SimpleHTTP Happstack.Server.Types
    Happstack.Server.Validation

hidden-modules:
    Happstack.Server.Internal.Clock Happstack.Server.Internal.LazyLiner
    Happstack.Server.SURI.ParseURI Paths_happstack_server

import-dirs:          /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-happstack-server
hs-libraries:         HShappstack-server-7.9.3-AWqQsKnqvBuEE3VepbIVri
depends:
    base-4.17.2.1 base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    blaze-html-0.9.2.0-Irz9BEYJh8t6ttuT8sjDNM bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1 exceptions-0.10.5
    extensible-exceptions-0.1.1.4-AGheGT2ZUDiCzp52FHEfjQ
    filepath-1.4.2.2 hslogger-1.3.2.0-1y0ReMtxTr7I5jlR5Eg9JE
    html-1.0.1.2-J6DAJfvF1D3ECsZlmS8hoI
    monad-control-1.0.3.1-4J7Msp6yzBzF6lrJ5tS8w8 mtl-2.2.2
    network-3.1.4.0-3FUQiZBqCiD6JAPkelGiT0
    network-uri-2.6.4.2-FdqTTZWnFNX96ukBHXQ0ED parsec-3.1.16.1
    process-1.6.18.0 sendfile-0.7.11.6-AQYZN7CS73jJJfMsQSuM3D
    syb-0.7.3-7hkxsEejTxP3yJx3PgFbmA
    system-filepath-0.4.14.1-8cD2XwL6mX7FIYWG2oPzUI text-2.0.2
    threads-0.5.1.8-ITUmUI7jW6PCflXCKAdvcC time-1.12.2
    transformers-0.5.6.2 transformers-base-0.4.6-AoHBLA4f1MkIOWPgcjyD0X
    unix-2.7.3 utf8-string-1.0.2-6nfZpgw1Ffy3MDnMPT0XX9
    xhtml-3000.2.2.1 zlib-0.7.0.0-9T3R7n3NMemFlfL7uoas2H

haddock-interfaces:
    /usr/share/doc/haskell-happstack-server/html/happstack-server.haddock

haddock-html:         /usr/share/doc/haskell-happstack-server/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

