#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hasql
version:              1.5.0.5
visibility:           public
id:                   hasql-1.5.0.5-Gq4SPMTcX2sFUYoFWBdV7r
key:                  hasql-1.5.0.5-Gq4SPMTcX2sFUYoFWBdV7r
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  66f428b6db90a3b8e2763dfe3041d152
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hasql
hs-libraries:         HShasql-1.5.0.5-Gq4SPMTcX2sFUYoFWBdV7r
depends:
    attoparsec-0.14.4-H9Y4iLHDqcP1CPr5BByOUl base-4.17.2.1
    bytestring-0.11.5.3
    bytestring-strict-builder-0.4.5.8-8y88PjzfugK7lNyvmt9UVr
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    dlist-1.0-BKgPi70fx5AJreCYiKxIIN
    hashable-1.4.4.0-5SoCNaysfySGuPwu0aljBu
    hashtables-1.4.1-41whIoTW471IbvoCxc31tV mtl-2.2.2
    postgresql-binary-0.12.5-A5wgm1JmY9EBeGowXDOjoG
    postgresql-libpq-0.9.5.0-ISIgXFjP19REFuF01eqmjw
    profunctors-5.6.3-54dftqYvfC87HlKhU8lZc text-2.0.2
    text-builder-0.6.7-Bwxvw7mwRpm6IsVYy4pVUG transformers-0.5.6.2
    vector-0.13.2.0-52P7Ozt5w3I6hi4WvheJB9

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

