#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hasql
version:              1.5.0.5
visibility:           public
id:                   hasql-1.5.0.5-22GlCAFASR56zPpYJQaDKy
key:                  hasql-1.5.0.5-22GlCAFASR56zPpYJQaDKy
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  cd7b05778800a7a306e8cc4759cf19e4
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hasql-1.5.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hasql
hs-libraries:         HShasql-1.5.0.5-22GlCAFASR56zPpYJQaDKy
depends:
    attoparsec-0.14.4-7XNA8JEEILfbCspmW44Jf base-4.17.2.1
    bytestring-0.11.5.3
    bytestring-strict-builder-0.4.5.8-EsXqr5AbDk29QXWOT9ql5y
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI
    hashable-1.4.6.0-8MG0S5dfyXU6lRGLMgbs1l
    hashtables-1.4.2-KkoXKI7zKbkCmeiJfzhtBM mtl-2.2.2
    postgresql-binary-0.12.5-7Cbdx67vBknKeaNKQN4ip7
    postgresql-libpq-0.9.5.0-ISIgXFjP19REFuF01eqmjw
    profunctors-5.6.3-1MRdcva7iD2KhEGv1D037x text-2.0.2
    text-builder-0.6.7-BqgEtODJbZNE5VKEPhajIF transformers-0.5.6.2
    vector-0.13.2.0-89nHvRrlFmk5zBBEvFgHzR

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

