#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.40
visibility:           public
id:                   hledger-lib-1.40-Gr8rAC9swnNGkAaa9lKulx
key:                  hledger-lib-1.40-Gr8rAC9swnNGkAaa9lKulx
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  cc6df92ce9bf9efa3b50b0aee43f7da6
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Csv Hledger.Write.Html Hledger.Write.Ods
    Hledger.Write.Spreadsheet Text.Tabular.AsciiWide

hidden-modules:       Text.WideString Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.40-Gr8rAC9swnNGkAaa9lKulx
depends:
    Decimal-0.5.2-CcAic6wGmJ0FIzncuSXSiE
    Glob-0.10.2-6MAgOFTrZnr5duqQgX06z4
    aeson-2.1.2.1-6ANjbGmrSDg8K6hz3VmYXP
    aeson-pretty-0.8.10-6UR3e8LgzRvIwEvRPnGaD4
    ansi-terminal-1.0.2-APpGXfviLhwGAqnzweVkae array-0.5.4.0
    base-4.17.2.1 base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA
    blaze-markup-0.8.3.0-6OwWTNZq6xt8UyuSSVrGHt bytestring-0.11.5.3
    call-stack-0.4.0-AAQ0PbHtRxA9hkeprsdCAo
    cassava-0.5.4.1-52ExbgZSUFH5YGctQcWfm5
    cassava-megaparsec-2.1.1-ChwEpnDe2c3HsXlQldHIfA
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-FtNV6vIncLUA7QVvan4Sl4 containers-0.6.7
    data-default-0.7.1.2-GUUW0V5lisrJnDmYs4YZIH deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-Ft0YtsMa91D72Bn1w4PjSa
    extra-1.7.16-I47Rfrva8J15uJNg6ub4mo
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.1-8RsWYaD9wUIAHk9wMaZVcf
    lucid-2.11.20250303-Den6fxowsBSASZ4VoXoys4
    megaparsec-9.7.0-11G1C9ltcKPC7KewoELwDN
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    pager-0.1.1.0-38zXtgcHyEv1ewl0l1RYJj
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-erYauGNUuI4VkqVZSMeGD
    regex-tdfa-1.3.2.4-FgXHJp0Jxc99bydELndP6q
    safe-0.3.21-95M34uAYizmIkn1zPFtQ36
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-GipkZ3gZ4qmGz8Rl0ke00W
    tasty-hunit-0.10.2-DGY4K8h8x95Gq7nOanNqrP template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2
    text-ansi-0.3.0.1-EyV3n2b0NCPHTTh0pgnedS time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-6WajAJaPEOH3f3auRxdjt7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

