#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.40
visibility:           public
id:                   hledger-lib-1.40-1Xl7je7PL8z3tpRvMVEZTK
key:                  hledger-lib-1.40-1Xl7je7PL8z3tpRvMVEZTK
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  3e11a5615540a4231b9dd8a2715474ee
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Csv Hledger.Write.Html Hledger.Write.Ods
    Hledger.Write.Spreadsheet Text.Tabular.AsciiWide

hidden-modules:       Text.WideString Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.40-1Xl7je7PL8z3tpRvMVEZTK
depends:
    Decimal-0.5.2-AmxrYKF6eEd399LgGvC3L2
    Glob-0.10.2-48UtlJmJwpN4f1EiCsVGO1
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    aeson-pretty-0.8.10-HWmn7v7pElT331cgWAs6cN
    ansi-terminal-1.0.2-9C7TLPMqFC3EnANnfcyKas array-0.5.4.0
    base-4.17.2.1 base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp
    blaze-markup-0.8.3.0-LhctOnkfqfP7twZcowViz5 bytestring-0.11.5.3
    call-stack-0.4.0-GLZYnk9HL8J8EgKDjlcntK
    cassava-0.5.4.0-8KHqa2xifEiGDVpKKEyXep
    cassava-megaparsec-2.1.1-Al5498Uaqg6LYT5uZA15s
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-FTsVzFO6Wyw8llPA3Znwfg containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-bICEgflrzO7g6LXiNCoYV
    extra-1.7.16-EVqIvjfjup2KjWh1SyzBng
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.1-BulZu7JI1gu76qCqKzERHo
    lucid-2.11.20250303-1Ts7BK1H6a42k8HYsSTcB3
    megaparsec-9.7.0-AMbJQB9BzBxf81g5ZS6Op
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    pager-0.1.1.0-7M065Dx00GhCMW21otiAuj
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-32yylESRFjw6n90rZ53c5v
    regex-tdfa-1.3.2.4-Ad5TdY6WlXxFUwxGz6iFnw
    safe-0.3.21-4A1yMugax9JCQWzW2mE78Z
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-FRQtZsdenVIBoQGCChJ79f
    tasty-hunit-0.10.1-G1mGdquhP0R7cV7ZT7D3rm template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2
    text-ansi-0.3.0.1-CsWXxjNAzl44Xyjod5JYRZ time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

