#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.41
visibility:           public
id:                   hledger-lib-1.41-BFYfKJYlOCLEyOkfP0kzFH
key:                  hledger-lib-1.41-BFYfKJYlOCLEyOkfP0kzFH
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  5ae9944886fc0c542e7800921d1642ad
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Currency
    Hledger.Data.Dates Hledger.Data.Errors Hledger.Data.Journal
    Hledger.Data.JournalChecks Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.Lucid Hledger.Write.Ods
    Hledger.Write.Spreadsheet Text.Tabular.AsciiWide Text.WideString

hidden-modules:       Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.41
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.41
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.41
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.41-BFYfKJYlOCLEyOkfP0kzFH
depends:
    Decimal-0.5.2-9MFIBXeyIJJLdqol8CveNZ
    Glob-0.10.2-7OdO7U8tqvmQYnj8MTg1C
    aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm
    aeson-pretty-0.8.10-7AZJj9bF88Xg9Byh4QeA2
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    blaze-html-0.9.2.0-LTAcRvwA4RX5X1Di6KFyT1
    blaze-markup-0.8.3.0-GZv1FLpSykS3DHygI81NMN bytestring-0.11.5.3
    call-stack-0.4.0-wdz1639SOC9HqySMka9DA
    cassava-0.5.4.1-6q0OLorsNaxKS3RilElHfN
    cassava-megaparsec-2.1.1-2Ldk9tOc5xO5IwRiAmHAhI
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-CLY4OzhkO79pVufYt5HDp containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-Hnbhk6lXhkELJeccFJQ8qk
    extra-1.7.16-84Gt3POgtfP5cuz093nHzi
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.1-6i2H1gKCNzR7vWnA8bxCQG
    lucid-2.11.20250303-LD7vyPATxZWJCLw60QjZxd
    megaparsec-9.7.0-EujlCtvd6hmm53pqN4SFa
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-5b0snePE1mm42Z9rumxIIV process-1.6.18.0
    regex-tdfa-1.3.2.4-4BRmOkLS3ql2wqEC5AAoF9
    safe-0.3.21-KEfOvx15i1f7ewOxq0ZYoN
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-2drm3vbeJH2JfJ6SzRblHQ
    tasty-hunit-0.10.2-AY4JgdA9yxL7uQSI42Qfjd template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2 time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-79maJZZuZDu8bRI1CHuoJG
    utf8-string-1.0.2-EpYvbnx7dwVHTduFVbgaKq

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

